/*
 * Decompiled with CFR 0.152.
 */
package sba.c.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.c.reactive.MappedProcessor;
import sba.c.reactive.ProcessorImpl;
import sba.c.reactive.Publisher;
import sba.c.reactive.Subscriber;
import sba.c.reactive.TransactionFailedException;
import sba.c.reactive.TransactionalProcessorImpl;
import sba.c.reactive.TransactionalSubscriber;
import sba.c.util.CheckedFunction;

public interface Processor<I, O>
extends Publisher<O>,
Subscriber<I> {
    public static <V> Iso<V> create() {
        return Processor.create(ForkJoinPool.commonPool());
    }

    public static <V> Iso<V> create(Executor executor) {
        return new ProcessorImpl(executor);
    }

    public static <V> TransactionalIso<V> createTransactional() {
        return Processor.createTransactional(ForkJoinPool.commonPool());
    }

    public static <V> TransactionalIso<V> createTransactional(Executor exec) {
        return new TransactionalProcessorImpl(exec);
    }

    default public <R> Processor<O, R> map(CheckedFunction<? super O, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<O, R>(mapper, this);
    }

    public void inject(O var1);

    public void fallbackHandler(@Nullable Subscriber<O> var1);

    public boolean closeIfUnsubscribed();

    public static interface TransactionalIso<V>
    extends Transactional<V, V>,
    Iso<V> {
    }

    public static interface Transactional<I, O>
    extends Processor<I, O>,
    Publisher<O>,
    TransactionalSubscriber<I> {
    }

    public static interface Iso<V>
    extends Processor<V, V> {
        @Override
        default public void inject(V element) {
            this.submit(element);
        }
    }
}

