/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.annotations;

import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.ArgumentDescription;
import sba.cl.Command;
import sba.cl.CommandManager;
import sba.cl.annotations.AnnotationAccessor;
import sba.cl.annotations.Argument;
import sba.cl.annotations.ArgumentExtractor;
import sba.cl.annotations.ArgumentMode;
import sba.cl.annotations.ArgumentParameterPair;
import sba.cl.annotations.CommandDescription;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandMethodPair;
import sba.cl.annotations.CommandPermission;
import sba.cl.annotations.Confirmation;
import sba.cl.annotations.FlagExtractor;
import sba.cl.annotations.Hidden;
import sba.cl.annotations.MetaFactory;
import sba.cl.annotations.MethodCommandExecutionHandler;
import sba.cl.annotations.ProxiedBy;
import sba.cl.annotations.Regex;
import sba.cl.annotations.SyntaxFragment;
import sba.cl.annotations.SyntaxParser;
import sba.cl.annotations.injection.ParameterInjectorRegistry;
import sba.cl.annotations.injection.RawArgs;
import sba.cl.annotations.parsers.MethodArgumentParser;
import sba.cl.annotations.parsers.Parser;
import sba.cl.annotations.specifier.Completions;
import sba.cl.annotations.suggestions.MethodSuggestionsProvider;
import sba.cl.annotations.suggestions.Suggestions;
import sba.cl.arguments.CommandArgument;
import sba.cl.arguments.flags.CommandFlag;
import sba.cl.arguments.parser.ArgumentParseResult;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.arguments.parser.ParserParameters;
import sba.cl.arguments.parser.StandardParameters;
import sba.cl.arguments.preprocessor.RegexPreprocessor;
import sba.cl.captions.Caption;
import sba.cl.context.CommandContext;
import sba.cl.execution.CommandExecutionHandler;
import sba.cl.extra.confirmation.CommandConfirmationManager;
import sba.cl.meta.CommandMeta;
import sba.cl.meta.SimpleCommandMeta;

public final class AnnotationParser<C> {
    public static final String INFERRED_ARGUMENT_NAME = "__INFERRED_ARGUMENT_NAME__";
    private final SyntaxParser syntaxParser = new SyntaxParser();
    private final ArgumentExtractor argumentExtractor = new ArgumentExtractor();
    private final CommandManager<C> manager;
    private final Map<Class<? extends Annotation>, Function<? extends Annotation, ParserParameters>> annotationMappers;
    private final Map<Class<? extends Annotation>, Function<? extends Annotation, BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>>> preprocessorMappers;
    private final Map<Class<? extends Annotation>, BiFunction<? extends Annotation, Command.Builder<C>, Command.Builder<C>>> builderModifiers;
    private final Map<Predicate<Method>, Function<MethodCommandExecutionHandler.CommandMethodContext<C>, MethodCommandExecutionHandler<C>>> commandMethodFactories;
    private final Class<C> commandSenderClass;
    private final MetaFactory metaFactory;
    private final FlagExtractor flagExtractor;

    public AnnotationParser(@NonNull CommandManager<C> manager, @NonNull Class<C> commandSenderClass, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.commandSenderClass = commandSenderClass;
        this.manager = manager;
        this.metaFactory = new MetaFactory(this, metaMapper);
        this.annotationMappers = new HashMap<Class<? extends Annotation>, Function<? extends Annotation, ParserParameters>>();
        this.preprocessorMappers = new HashMap<Class<? extends Annotation>, Function<? extends Annotation, BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>>>>();
        this.builderModifiers = new HashMap<Class<? extends Annotation>, BiFunction<? extends Annotation, Command.Builder<C>, Command.Builder<C>>>();
        this.commandMethodFactories = new HashMap<Predicate<Method>, Function<MethodCommandExecutionHandler.CommandMethodContext<C>, MethodCommandExecutionHandler<C>>>();
        this.flagExtractor = new FlagExtractor(manager);
        this.registerAnnotationMapper(CommandDescription.class, d -> ParserParameters.single(StandardParameters.DESCRIPTION, d.value()));
        this.registerPreprocessorMapper(Regex.class, annotation -> RegexPreprocessor.of(annotation.value(), Caption.of(annotation.failureCaption())));
        this.getParameterInjectorRegistry().registerInjector(String[].class, (context, annotations) -> annotations.annotation(RawArgs.class) == null ? null : context.getRawInput().toArray(new String[0]));
    }

    static <A extends Annotation> @Nullable A getAnnotationRecursively(@NonNull AnnotationAccessor annotations, @NonNull Class<A> clazz, @NonNull Set<Class<? extends Annotation>> checkedAnnotations) {
        A innerCandidate = null;
        for (Annotation annotation : annotations.annotations()) {
            A inner;
            if (!checkedAnnotations.add(annotation.annotationType())) continue;
            if (annotation.annotationType().equals(clazz)) {
                return (A)annotation;
            }
            if (annotation.annotationType().getPackage().getName().startsWith("java.lang") || (inner = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of(annotation.annotationType()), clazz, checkedAnnotations)) == null) continue;
            innerCandidate = inner;
        }
        return innerCandidate;
    }

    static <A extends Annotation> @Nullable A getMethodOrClassAnnotation(@NonNull Method method, @NonNull Class<A> clazz) {
        A annotation = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of(method), clazz, new HashSet<Class<? extends Annotation>>());
        if (annotation == null) {
            annotation = AnnotationParser.getAnnotationRecursively(AnnotationAccessor.of(method.getDeclaringClass()), clazz, new HashSet<Class<? extends Annotation>>());
        }
        return annotation;
    }

    static <A extends Annotation> boolean methodOrClassHasAnnotation(@NonNull Method method, @NonNull Class<A> clazz) {
        return AnnotationParser.getMethodOrClassAnnotation(method, clazz) != null;
    }

    public @NonNull CommandManager<C> manager() {
        return this.manager;
    }

    public void registerCommandExecutionMethodFactory(@NonNull Predicate<@NonNull Method> predicate, @NonNull Function<MethodCommandExecutionHandler.CommandMethodContext<C>, MethodCommandExecutionHandler<C>> function) {
        this.commandMethodFactories.put(predicate, function);
    }

    public <A extends Annotation> void registerBuilderModifier(@NonNull Class<A> annotation, @NonNull BiFunction<A, Command.Builder<C>, Command.Builder<C>> builderModifier) {
        this.builderModifiers.put(annotation, builderModifier);
    }

    public <A extends Annotation> void registerAnnotationMapper(@NonNull Class<A> annotation, @NonNull Function<@NonNull A, @NonNull ParserParameters> mapper) {
        this.annotationMappers.put(annotation, mapper);
    }

    public <A extends Annotation> void registerPreprocessorMapper(@NonNull Class<A> annotation, @NonNull Function<A, BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> preprocessorMapper) {
        this.preprocessorMappers.put(annotation, preprocessorMapper);
    }

    public @NonNull ParameterInjectorRegistry<C> getParameterInjectorRegistry() {
        return this.manager.parameterInjectorRegistry();
    }

    public <T> @NonNull Collection<@NonNull Command<C>> parse(@NonNull T instance) {
        this.parseSuggestions(instance);
        this.parseParsers(instance);
        Method[] methods = instance.getClass().getDeclaredMethods();
        ArrayList<CommandMethodPair> commandMethodPairs = new ArrayList<CommandMethodPair>();
        for (Method method : methods) {
            CommandMethod commandMethod = method.getAnnotation(CommandMethod.class);
            if (commandMethod == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(String.format("@CommandMethod annotated method '%s' is static! @CommandMethod annotated methods should not be static.", method.getName()));
            }
            commandMethodPairs.add(new CommandMethodPair(method, commandMethod));
        }
        Collection<Command<C>> commands = this.construct(instance, commandMethodPairs);
        for (Command<C> command : commands) {
            this.manager.command(command);
        }
        return commands;
    }

    private <T> void parseSuggestions(@NonNull T instance) {
        for (Method method : instance.getClass().getMethods()) {
            Suggestions suggestions = method.getAnnotation(Suggestions.class);
            if (suggestions == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!(method.getParameterCount() == 2 && method.getReturnType().equals(List.class) && method.getParameters()[0].getType().equals(CommandContext.class) && method.getParameters()[1].getType().equals(String.class))) {
                throw new IllegalArgumentException(String.format("@Suggestions annotated method '%s' in class '%s' does not have the correct signature", method.getName(), instance.getClass().getCanonicalName()));
            }
            try {
                this.manager.getParserRegistry().registerSuggestionProvider(suggestions.value(), new MethodSuggestionsProvider(instance, method));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void parseParsers(@NonNull T instance) {
        for (Method method : instance.getClass().getMethods()) {
            Parser parser = method.getAnnotation(Parser.class);
            if (parser == null) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (method.getParameterCount() != 2 || method.getReturnType().equals(Void.class) || !method.getParameters()[0].getType().equals(CommandContext.class) || !method.getParameters()[1].getType().equals(Queue.class)) {
                throw new IllegalArgumentException(String.format("@Parser annotated method '%s' in class '%s' does not have the correct signature", method.getName(), instance.getClass().getCanonicalName()));
            }
            try {
                BiFunction suggestionsProvider = parser.suggestions().isEmpty() ? (context, input) -> Collections.emptyList() : this.manager.getParserRegistry().getSuggestionProvider(parser.suggestions()).orElseThrow(() -> new NullPointerException(String.format("Cannot find the suggestions provider with name '%s'", parser.suggestions())));
                MethodArgumentParser methodArgumentParser = new MethodArgumentParser(suggestionsProvider, instance, method);
                Function parserFunction = parameters -> methodArgumentParser;
                if (parser.name().isEmpty()) {
                    this.manager.getParserRegistry().registerParserSupplier(TypeToken.get(method.getGenericReturnType()), parserFunction);
                    continue;
                }
                this.manager.getParserRegistry().registerNamedParserSupplier(parser.name(), parserFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private @NonNull Collection<@NonNull Command<C>> construct(@NonNull Object instance, @NonNull Collection<@NonNull CommandMethodPair> methodPairs) {
        AnnotationAccessor classAnnotations = AnnotationAccessor.of(instance.getClass());
        CommandMethod classCommandMethod = classAnnotations.annotation(CommandMethod.class);
        String syntaxPrefix = classCommandMethod == null ? "" : classCommandMethod.value() + " ";
        ArrayList<Command<C>> commands = new ArrayList<Command<C>>();
        for (CommandMethodPair commandMethodPair : methodPairs) {
            void var22_23;
            CommandPermission commandPermission;
            CommandMethod commandMethod = commandMethodPair.getCommandMethod();
            Method method = commandMethodPair.getMethod();
            String syntax = syntaxPrefix + commandMethod.value();
            List<SyntaxFragment> tokens = this.syntaxParser.apply(syntax);
            String commandToken = syntax.split(" ")[0].split("\\|")[0];
            CommandManager<C> manager = this.manager;
            SimpleCommandMeta.Builder metaBuilder = SimpleCommandMeta.builder().with(this.metaFactory.apply(method));
            if (AnnotationParser.methodOrClassHasAnnotation(method, Confirmation.class)) {
                metaBuilder.with(CommandConfirmationManager.META_CONFIRMATION_REQUIRED, true);
            }
            Command.Builder<Object> builder = manager.commandBuilder(commandToken, tokens.get(0).getMinor(), metaBuilder.build());
            Collection<ArgumentParameterPair> arguments = this.argumentExtractor.apply(method);
            Collection<CommandFlag<?>> flags = this.flagExtractor.apply(method);
            HashMap commandArguments = new HashMap();
            HashMap argumentDescriptions = new HashMap();
            for (ArgumentParameterPair argumentParameterPair : arguments) {
                CommandArgument<C, ?> argument = this.buildArgument(method, this.findSyntaxFragment(tokens, argumentParameterPair.argumentName()), argumentParameterPair);
                commandArguments.put(argument.getName(), argument);
                argumentDescriptions.put(argument, argumentParameterPair.getArgument().description());
            }
            boolean commandNameFound = false;
            for (Parameter[] token : tokens) {
                if (!commandNameFound) {
                    commandNameFound = true;
                    continue;
                }
                if (token.getArgumentMode() == ArgumentMode.LITERAL) {
                    builder = builder.literal(token.getMajor(), token.getMinor().toArray(new String[0]));
                    continue;
                }
                CommandArgument argument = (CommandArgument)commandArguments.get(token.getMajor());
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Found no mapping for argument '%s' in method '%s'", token.getMajor(), method.getName()));
                }
                String description = argumentDescriptions.getOrDefault(argument, "");
                builder = builder.argument(argument, ArgumentDescription.of(description));
            }
            Object var22_27 = null;
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isAnnotationPresent(Argument.class) || !this.commandSenderClass.isAssignableFrom(parameter.getType())) continue;
                Class<?> clazz = parameter.getType();
                break;
            }
            if ((commandPermission = AnnotationParser.getMethodOrClassAnnotation(method, CommandPermission.class)) != null) {
                builder = builder.permission(commandPermission.value());
            }
            if (commandMethod.requiredSender() != Object.class) {
                builder = builder.senderType(commandMethod.requiredSender());
            } else if (var22_23 != null) {
                builder = builder.senderType((Class<Object>)var22_23);
            }
            try {
                MethodCommandExecutionHandler.CommandMethodContext context = new MethodCommandExecutionHandler.CommandMethodContext(instance, commandArguments, method, this.getParameterInjectorRegistry());
                CommandExecutionHandler commandExecutionHandler = new MethodCommandExecutionHandler(context);
                for (Map.Entry<Predicate<Method>, Function<MethodCommandExecutionHandler.CommandMethodContext<C>, MethodCommandExecutionHandler<C>>> entry : this.commandMethodFactories.entrySet()) {
                    if (!entry.getKey().test(method)) continue;
                    commandExecutionHandler = entry.getValue().apply(context);
                    break;
                }
                builder = builder.handler(commandExecutionHandler);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to construct command execution handler", e);
            }
            if (AnnotationParser.methodOrClassHasAnnotation(method, Hidden.class)) {
                builder = builder.hidden();
            }
            for (CommandFlag<?> flag : flags) {
                builder = builder.flag(flag);
            }
            for (Annotation annotation : AnnotationAccessor.of(classAnnotations, AnnotationAccessor.of(method)).annotations()) {
                BiFunction<Annotation, Command.Builder<C>, Command.Builder<C>> biFunction = this.builderModifiers.get(annotation.annotationType());
                if (biFunction == null) continue;
                builder = biFunction.apply(annotation, builder);
            }
            Command<C> builtCommand = builder.build();
            commands.add(builtCommand);
            if (!method.isAnnotationPresent(ProxiedBy.class)) continue;
            ProxiedBy proxyAnnotation = method.getAnnotation(ProxiedBy.class);
            String string = proxyAnnotation.value();
            if (string.contains(" ")) {
                throw new IllegalArgumentException("@ProxiedBy proxies may only contain single literals");
            }
            Command.Builder<C> proxyBuilder = manager.commandBuilder(string, builtCommand.getCommandMeta(), new String[0]).proxies(builtCommand);
            if (proxyAnnotation.hidden()) {
                proxyBuilder = proxyBuilder.hidden();
            }
            manager.command(proxyBuilder.build());
        }
        return commands;
    }

    private @NonNull SyntaxFragment findSyntaxFragment(@NonNull List<@NonNull SyntaxFragment> fragments, @NonNull String argumentName) {
        for (SyntaxFragment fragment : fragments) {
            if (fragment.getArgumentMode() == ArgumentMode.LITERAL || !fragment.getMajor().equals(argumentName)) continue;
            return fragment;
        }
        throw new IllegalArgumentException("Argument is not declared in syntax: " + argumentName);
    }

    private @NonNull CommandArgument<C, ?> buildArgument(@NonNull Method method, @Nullable SyntaxFragment syntaxFragment, @NonNull ArgumentParameterPair argumentPair) {
        Parameter parameter = argumentPair.getParameter();
        List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
        TypeToken<?> token = TypeToken.get(parameter.getParameterizedType());
        ParserParameters parameters = this.manager.getParserRegistry().parseAnnotations(token, annotations);
        ArgumentParser<C, Object> parser = argumentPair.getArgument().parserName().isEmpty() ? this.manager.getParserRegistry().createParser(token, parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' in method '%s' has parser '%s' but no parser exists for that type", parameter.getName(), method.getName(), token.getType().getTypeName()))) : this.manager.getParserRegistry().createParser(argumentPair.getArgument().parserName(), parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' in method '%s' has parser '%s' but no parser exists for that type", parameter.getName(), method.getName(), token.getType().getTypeName())));
        if (syntaxFragment == null || syntaxFragment.getArgumentMode() == ArgumentMode.LITERAL) {
            throw new IllegalArgumentException(String.format("Invalid command argument '%s' in method '%s': Missing syntax mapping", argumentPair.argumentName(), method.getName()));
        }
        Argument argument = argumentPair.getArgument();
        CommandArgument.Builder<C, ?> argumentBuilder = CommandArgument.ofType(parameter.getType(), argumentPair.argumentName());
        if (syntaxFragment.getArgumentMode() == ArgumentMode.OPTIONAL) {
            if (argument.defaultValue().isEmpty()) {
                argumentBuilder.asOptional();
            } else {
                argumentBuilder.asOptionalWithDefault(argument.defaultValue());
            }
        } else {
            argumentBuilder.asRequired();
        }
        Completions completions = parameter.getDeclaredAnnotation(Completions.class);
        if (completions != null) {
            List<String> suggestions = Arrays.asList(completions.value().replace(" ", "").split(","));
            argumentBuilder.withSuggestionsProvider((commandContext, input) -> suggestions);
        } else if (!argument.suggestions().isEmpty()) {
            String suggestionProviderName = argument.suggestions();
            Optional<BiFunction<CommandContext<C>, String, List<String>>> suggestionsFunction = this.manager.getParserRegistry().getSuggestionProvider(suggestionProviderName);
            argumentBuilder.withSuggestionsProvider(suggestionsFunction.orElseThrow(() -> new IllegalArgumentException(String.format("There is no suggestion provider with name '%s'. Did you forget to register it?", suggestionProviderName))));
        }
        CommandArgument<C, ?> builtArgument = argumentBuilder.manager(this.manager).withParser(parser).build();
        for (Annotation annotation : annotations) {
            Function<Annotation, BiFunction<CommandContext<C>, Queue<String>, ArgumentParseResult<Boolean>>> preprocessorMapper = this.preprocessorMappers.get(annotation.annotationType());
            if (preprocessorMapper == null) continue;
            BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>> preprocessor = preprocessorMapper.apply(annotation);
            builtArgument.addPreprocessor(preprocessor);
        }
        return builtArgument;
    }

    @NonNull Map<@NonNull Class<@NonNull ? extends Annotation>, @NonNull Function<@NonNull ? extends Annotation, @NonNull ParserParameters>> getAnnotationMappers() {
        return this.annotationMappers;
    }
}

