/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.arguments.compound;

import io.leangen.geantyref.TypeToken;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.CommandManager;
import sba.cl.arguments.compound.CompoundArgument;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.arguments.parser.ParserParameters;
import sba.cl.arguments.parser.ParserRegistry;
import sba.cl.types.tuples.Triplet;

public class ArgumentTriplet<C, U, V, W, O>
extends CompoundArgument<Triplet<U, V, W>, C, O> {
    protected ArgumentTriplet(boolean required, @NonNull String name, @NonNull Triplet<@NonNull String, @NonNull String, @NonNull String> names, @NonNull Triplet<@NonNull Class<U>, @NonNull Class<V>, @NonNull Class<W>> types, @NonNull Triplet<@NonNull ArgumentParser<C, U>, @NonNull ArgumentParser<C, V>, @NonNull ArgumentParser<C, W>> parserTriplet, @NonNull BiFunction<@NonNull C, @NonNull Triplet<U, @NonNull V, @NonNull W>, @NonNull O> mapper, @NonNull TypeToken<O> valueType) {
        super(required, name, names, parserTriplet, types, mapper, (Object[] o) -> Triplet.of(o[0], o[1], o[2]), valueType);
    }

    public static <C, U, V, W> @NonNull ArgumentTripletIntermediaryBuilder<@NonNull C, @NonNull U, @NonNull V, @NonNull W> of(@NonNull CommandManager<C> manager, @NonNull String name, @NonNull Triplet<@NonNull String, @NonNull String, @NonNull String> names, @NonNull Triplet<@NonNull Class<U>, @NonNull Class<V>, @NonNull Class<W>> types) {
        ParserRegistry<C> parserRegistry = manager.getParserRegistry();
        ArgumentParser<C, U> firstParser = parserRegistry.createParser(TypeToken.get(types.getFirst()), ParserParameters.empty()).orElseThrow(() -> new IllegalArgumentException("Could not create parser for primary type"));
        ArgumentParser<C, V> secondaryParser = parserRegistry.createParser(TypeToken.get(types.getSecond()), ParserParameters.empty()).orElseThrow(() -> new IllegalArgumentException("Could not create parser for secondary type"));
        ArgumentParser<C, W> tertiaryParser = parserRegistry.createParser(TypeToken.get(types.getThird()), ParserParameters.empty()).orElseThrow(() -> new IllegalArgumentException("Could not create parser for tertiary type"));
        return new ArgumentTripletIntermediaryBuilder(true, name, names, Triplet.of(firstParser, secondaryParser, tertiaryParser), types);
    }

    public static final class ArgumentTripletIntermediaryBuilder<C, U, V, W> {
        private final boolean required;
        private final String name;
        private final Triplet<ArgumentParser<C, U>, ArgumentParser<C, V>, ArgumentParser<C, W>> parserTriplet;
        private final Triplet<String, String, String> names;
        private final Triplet<Class<U>, Class<V>, Class<W>> types;

        private ArgumentTripletIntermediaryBuilder(boolean required, @NonNull String name, @NonNull Triplet<@NonNull String, @NonNull String, @NonNull String> names, @NonNull Triplet<@NonNull ArgumentParser<C, U>, @NonNull ArgumentParser<C, V>, @NonNull ArgumentParser<C, W>> parserTriplet, @NonNull Triplet<@NonNull Class<U>, @NonNull Class<V>, @NonNull Class<W>> types) {
            this.required = required;
            this.name = name;
            this.names = names;
            this.parserTriplet = parserTriplet;
            this.types = types;
        }

        public @NonNull ArgumentTriplet<@NonNull C, @NonNull U, @NonNull V, @NonNull W, Triplet<U, V, W>> simple() {
            return new ArgumentTriplet<Object, U, V, W, Triplet>(this.required, this.name, this.names, this.types, this.parserTriplet, (sender, triplet) -> triplet, new TypeToken<Triplet<U, V, W>>(){});
        }

        public <O> @NonNull ArgumentTriplet<@NonNull C, @NonNull U, @NonNull V, @NonNull W, @NonNull O> withMapper(@NonNull TypeToken<O> clazz, @NonNull BiFunction<@NonNull C, @NonNull Triplet<@NonNull U, @NonNull V, @NonNull W>, @NonNull O> mapper) {
            return new ArgumentTriplet<C, U, V, W, O>(this.required, this.name, this.names, this.types, this.parserTriplet, mapper, clazz);
        }

        public <O> @NonNull ArgumentTriplet<C, U, V, W, O> withMapper(@NonNull Class<O> clazz, @NonNull BiFunction<@NonNull C, @NonNull Triplet<@NonNull U, @NonNull V, @NonNull W>, @NonNull O> mapper) {
            return new ArgumentTriplet<C, U, V, W, O>(this.required, this.name, this.names, this.types, this.parserTriplet, mapper, TypeToken.get(clazz));
        }
    }
}

