/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.brigadier.argument;

import com.mojang.brigadier.StringReader;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.brigadier.argument.StringReaderAsQueue;

final class StringReaderAsQueueImpl {
    private StringReaderAsQueueImpl() {
    }

    static int nextWhitespace(String input, int startIdx) {
        int length = input.length();
        for (int i = startIdx; i < length; ++i) {
            if (!Character.isWhitespace(input.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static final class Wrapping
    implements StringReaderAsQueue {
        private final StringReader original;
        private int nextSpaceIdx;
        private @Nullable String nextWord;

        Wrapping(StringReader original) {
            this.original = original;
            this.nextSpaceIdx = original.getCursor() - 1;
            this.advance();
        }

        @Override
        public StringReader getOriginal() {
            return this.original;
        }

        private void advance() {
            int startOfNextWord = this.nextSpaceIdx + 1;
            this.nextSpaceIdx = StringReaderAsQueueImpl.nextWhitespace(this.original.getString(), startOfNextWord);
            if (this.nextSpaceIdx != -1) {
                this.nextWord = this.original.getString().substring(startOfNextWord, this.nextSpaceIdx);
            } else if (startOfNextWord < this.original.getTotalLength()) {
                this.nextWord = this.original.getString().substring(startOfNextWord);
                this.nextSpaceIdx = this.original.getTotalLength() + 1;
            } else {
                this.nextWord = null;
            }
            this.original.setCursor(startOfNextWord);
        }

        @Override
        public String poll() {
            String next = this.peek();
            if (next != null) {
                this.advance();
            }
            return next;
        }

        @Override
        public String peek() {
            return this.nextWord;
        }

        @Override
        public int size() {
            if (this.nextWord == null) {
                return 0;
            }
            int counter = 1;
            int i = this.nextSpaceIdx;
            while (i != -1 && i < this.original.getTotalLength()) {
                ++counter;
                i = StringReaderAsQueueImpl.nextWhitespace(this.original.getString(), i + 1);
            }
            return counter;
        }

        @Override
        public boolean remove(Object o) {
            if (Objects.equals(o, this.nextWord)) {
                this.advance();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            StringReaderAsQueue.super.clear();
            this.nextWord = null;
            this.nextSpaceIdx = -1;
        }
    }
}

