/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.bukkit.parsers.location;

import java.util.Queue;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.arguments.parser.ArgumentParseResult;
import sba.cl.arguments.parser.ArgumentParser;
import sba.cl.arguments.standard.DoubleArgument;
import sba.cl.bukkit.parsers.PlayerArgument;
import sba.cl.bukkit.parsers.location.LocationCoordinate;
import sba.cl.bukkit.parsers.location.LocationCoordinateType;
import sba.cl.context.CommandContext;
import sba.cl.exceptions.parsing.NoInputProvidedException;

public final class LocationCoordinateParser<C>
implements ArgumentParser<C, LocationCoordinate> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull LocationCoordinate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        double coordinate;
        LocationCoordinateType locationCoordinateType;
        String input = inputQueue.peek();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(PlayerArgument.PlayerParser.class, commandContext));
        }
        if (input.startsWith("^")) {
            locationCoordinateType = LocationCoordinateType.LOCAL;
            input = input.substring(1);
        } else if (input.startsWith("~")) {
            locationCoordinateType = LocationCoordinateType.RELATIVE;
            input = input.substring(1);
        } else {
            locationCoordinateType = LocationCoordinateType.ABSOLUTE;
        }
        try {
            coordinate = input.isEmpty() ? 0.0 : Double.parseDouble(input);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new DoubleArgument.DoubleParseException(input, new DoubleArgument.DoubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), commandContext));
        }
        inputQueue.remove();
        return ArgumentParseResult.success(LocationCoordinate.of(locationCoordinateType, coordinate));
    }
}

