/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.paper;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.cl.CommandManager;
import sba.cl.CommandTree;
import sba.cl.brigadier.CloudBrigadierManager;
import sba.cl.bukkit.BukkitCommandManager;
import sba.cl.bukkit.CloudBukkitCapabilities;
import sba.cl.execution.CommandExecutionCoordinator;
import sba.cl.paper.AsyncCommandSuggestionsListener;
import sba.cl.paper.PaperBrigadierListener;

public class PaperCommandManager<C>
extends BukkitCommandManager<C> {
    private PaperBrigadierListener<C> paperBrigadierListener = null;

    public PaperCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<CommandTree<C>, CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<CommandSender, C> commandSenderMapper, @NonNull Function<C, CommandSender> backwardsCommandSenderMapper) throws Exception {
        super(owningPlugin, commandExecutionCoordinator, commandSenderMapper, backwardsCommandSenderMapper);
    }

    public static @NonNull PaperCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<@NonNull CommandSender>, @NonNull CommandExecutionCoordinator<@NonNull CommandSender>> commandExecutionCoordinator) throws Exception {
        return new PaperCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, UnaryOperator.identity(), UnaryOperator.identity());
    }

    @Override
    public void registerBrigadier() throws BukkitCommandManager.BrigadierFailureException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (!this.queryCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            super.registerBrigadier();
        } else {
            try {
                this.paperBrigadierListener = new PaperBrigadierListener(this);
                Bukkit.getPluginManager().registerEvents(this.paperBrigadierListener, this.getOwningPlugin());
            }
            catch (Throwable e) {
                throw new BukkitCommandManager.BrigadierFailureException(BukkitCommandManager.BrigadierFailureReason.PAPER_BRIGADIER_INITIALIZATION_FAILURE, e);
            }
        }
    }

    @Override
    public @Nullable CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.paperBrigadierListener != null) {
            return this.paperBrigadierListener.brigadierManager();
        }
        return super.brigadierManager();
    }

    public void registerAsynchronousCompletions() throws IllegalStateException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        if (!this.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            throw new IllegalStateException("Failed to register asynchronous command completion listener.");
        }
        Bukkit.getServer().getPluginManager().registerEvents(new AsyncCommandSuggestionsListener(this), this.getOwningPlugin());
    }
}

