/*
 * Decompiled with CFR 0.152.
 */
package sba.k.a.p.bukkit;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;
import sba.k.a.p.bukkit.CraftBukkitFacet;
import sba.k.a.p.bukkit.MinecraftReflection;
import sba.k.a.p.bukkit.SpigotFacet;
import sba.k.a.p.facet.Facet;
import sba.k.a.p.facet.FacetComponentFlattener;
import sba.k.a.t.flattener.ComponentFlattener;
import sba.k.a.t.serializer.gson.GsonComponentSerializer;
import sba.k.a.t.serializer.gson.legacyimpl.NBTLegacyHoverEventSerializer;
import sba.k.a.t.serializer.legacy.LegacyComponentSerializer;

public final class BukkitComponentSerializer {
    private static final boolean IS_1_16 = MinecraftReflection.findEnum(Material.class, "NETHERITE_PICKAXE") != null;
    private static final Collection<FacetComponentFlattener.Translator<Server>> TRANSLATORS = Facet.of(SpigotFacet.Translator::new, CraftBukkitFacet.Translator::new);
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final GsonComponentSerializer GSON_SERIALIZER;
    static final ComponentFlattener FLATTENER;

    private BukkitComponentSerializer() {
    }

    @NotNull
    public static LegacyComponentSerializer legacy() {
        return LEGACY_SERIALIZER;
    }

    @NotNull
    public static GsonComponentSerializer gson() {
        return GSON_SERIALIZER;
    }

    static {
        FLATTENER = FacetComponentFlattener.get(Bukkit.getServer(), TRANSLATORS);
        if (IS_1_16) {
            LEGACY_SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().flattener(FLATTENER).build();
            GSON_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).build();
        } else {
            LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').flattener(FLATTENER).build();
            GSON_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).emitLegacyHoverEvent().downsampleColors().build();
        }
    }
}

