/*
 * Decompiled with CFR 0.152.
 */
package sba.si;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import sba.si.builder.InventorySetBuilder;
import sba.si.inventory.InventorySet;
import sba.si.inventory.SubInventory;
import sba.si.placeholders.PlaceholderParser;
import sba.si.render.InventoryRenderer;
import sba.sl.Core;
import sba.sl.pa.Player;
import sba.sl.u.annotations.AbstractService;
import sba.sl.u.annotations.ServiceDependencies;

@AbstractService(value="sba.si.{platform}.SimpleInventories{Platform}")
@ServiceDependencies(dependsOn={Core.class})
public abstract class SimpleInventoriesCore {
    protected Logger logger;
    protected static SimpleInventoriesCore core;

    protected SimpleInventoriesCore(Logger logger) {
        if (core != null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore is already initialized.");
        }
        core = this;
        this.logger = logger;
    }

    public static InventoryRenderer openInventory(Player playerWrapper, SubInventory subInventory) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        InventoryRenderer renderer = core.openInventory0(playerWrapper, subInventory);
        renderer.render();
        return renderer;
    }

    protected abstract InventoryRenderer openInventory0(Player var1, SubInventory var2);

    public static Logger getLogger() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return SimpleInventoriesCore.core.logger;
    }

    public static Optional<InventoryRenderer> getInventoryRenderer(Player playerWrapper) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return Optional.ofNullable(core.getInventoryRenderer0(playerWrapper));
    }

    protected abstract InventoryRenderer getInventoryRenderer0(Player var1);

    public static List<InventoryRenderer> getAllInventoryRenderersForSubInventory(SubInventory subInventory) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getAllInventoryRenderersForSubInventory0(subInventory);
    }

    protected abstract List<InventoryRenderer> getAllInventoryRenderersForSubInventory0(SubInventory var1);

    public static List<InventoryRenderer> getAllInventoryRenderersForInventorySet(InventorySet inventorySet) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getAllInventoryRenderersForInventorySet0(inventorySet);
    }

    protected abstract List<InventoryRenderer> getAllInventoryRenderersForInventorySet0(InventorySet var1);

    public static Object readConfigurationSerializable(Map<String, Object> configuration) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.readConfigurationSerializable0(configuration);
    }

    protected abstract Object readConfigurationSerializable0(Map<String, Object> var1);

    public static void registerPlatformSpecificPlaceholders(Map<String, PlaceholderParser> placeholders) {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        core.registerPlatformSpecificPlaceholders0(placeholders);
    }

    protected abstract void registerPlatformSpecificPlaceholders0(Map<String, PlaceholderParser> var1);

    public static void runJar(File file) throws Exception {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        core.runJar0(file);
    }

    protected abstract void runJar0(File var1) throws Exception;

    public static Path getRootPath() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return core.getRootPath0();
    }

    protected abstract Path getRootPath0();

    public static InventorySetBuilder builder() {
        return InventorySetBuilder.of(new InventorySet());
    }
}

