/*
 * Decompiled with CFR 0.152.
 */
package sba.si.bukkit;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import sba.si.SimpleInventoriesCore;
import sba.si.bukkit.action.BukkitClickActionHandler;
import sba.si.bukkit.action.BukkitCloseInventoryActionHandler;
import sba.si.bukkit.action.BukkitItemDragActionHandler;
import sba.si.bukkit.action.BukkitItemMoveActionHandler;
import sba.si.bukkit.holder.AbstractHolder;
import sba.si.bukkit.placeholders.WorldPlaceholderParser;
import sba.si.bukkit.render.BukkitInventoryRenderer;
import sba.si.bukkit.utils.InventoryUtils;
import sba.si.inventory.InventorySet;
import sba.si.inventory.SubInventory;
import sba.si.placeholders.PlaceholderParser;
import sba.si.render.InventoryRenderer;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnEnable;

@Service
public class SimpleInventoriesBukkit
extends SimpleInventoriesCore {
    private final Plugin plugin;

    public SimpleInventoriesBukkit(Plugin plugin) {
        super(plugin.getLogger());
        this.plugin = plugin;
    }

    @OnEnable
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitClickActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitCloseInventoryActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitItemDragActionHandler(), this.plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitItemMoveActionHandler(), this.plugin);
    }

    public static Plugin getPlugin() {
        if (core == null) {
            throw new UnsupportedOperationException("SimpleInventoriesCore isn't initialized yet.");
        }
        return ((SimpleInventoriesBukkit)SimpleInventoriesBukkit.core).plugin;
    }

    @Override
    protected BukkitInventoryRenderer openInventory0(sba.sl.pa.Player playerWrapper, SubInventory subInventory) {
        return new BukkitInventoryRenderer(playerWrapper, subInventory, 0);
    }

    @Override
    protected InventoryRenderer getInventoryRenderer0(sba.sl.pa.Player playerWrapper) {
        Player player = playerWrapper.as(Player.class);
        return this.getInventoryRenderer0(player);
    }

    protected InventoryRenderer getInventoryRenderer0(Player player) {
        Inventory top = player.getOpenInventory().getTopInventory();
        InventoryHolder topHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(top);
        if (topHolder instanceof AbstractHolder) {
            return ((AbstractHolder)topHolder).getInventoryRenderer();
        }
        return null;
    }

    @Override
    protected List<InventoryRenderer> getAllInventoryRenderersForSubInventory0(SubInventory subInventory) {
        return Bukkit.getOnlinePlayers().stream().map(this::getInventoryRenderer0).filter(Objects::nonNull).filter(inventoryRenderer -> inventoryRenderer.getSubInventory() == subInventory).collect(Collectors.toList());
    }

    @Override
    protected List<InventoryRenderer> getAllInventoryRenderersForInventorySet0(InventorySet inventorySet) {
        return Bukkit.getOnlinePlayers().stream().map(this::getInventoryRenderer0).filter(Objects::nonNull).filter(inventoryRenderer -> inventoryRenderer.getSubInventory().getInventorySet() == inventorySet).collect(Collectors.toList());
    }

    @Override
    protected Object readConfigurationSerializable0(Map<String, Object> configuration) {
        try {
            return ConfigurationSerialization.deserializeObject(configuration);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return configuration;
        }
    }

    @Override
    protected void registerPlatformSpecificPlaceholders0(Map<String, PlaceholderParser> placeholders) {
        placeholders.put("world", new WorldPlaceholderParser());
    }

    @Override
    protected void runJar0(File file) throws Exception {
        Plugin plugin = Bukkit.getPluginManager().loadPlugin(file);
        Bukkit.getPluginManager().enablePlugin(plugin);
    }

    @Override
    protected Path getRootPath0() {
        return this.plugin.getDataFolder().toPath();
    }
}

