/*
 * Decompiled with CFR 0.152.
 */
package sba.si.bukkit.render;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import sba.si.bukkit.holder.AbstractHolder;
import sba.si.bukkit.holder.StandardInventoryHolder;
import sba.si.bukkit.utils.InventoryUtils;
import sba.si.inventory.LocalOptions;
import sba.si.inventory.SubInventory;
import sba.si.render.InventoryRenderer;
import sba.sl.i.ItemStack;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.ThreadProperty;

public class BukkitInventoryRenderer
extends InventoryRenderer {
    private AbstractHolder inventoryHolder;
    private static final List<String> SIZEABLE_CONTAINERS = List.of("CHEST", "ENDER_CHEST", "SHULKER_BOX", "BARREL");

    public BukkitInventoryRenderer(sba.sl.pa.Player player, SubInventory subInventory, int page) {
        super(player, subInventory, page);
    }

    @Override
    protected void renderOnPlatform() {
        LocalOptions options = this.subInventory.getLocalOptions();
        if (this.inventoryHolder != null && this.inventoryHolder.getInventory().getSize() == options.getRenderActualRows() * options.getItemsOnRow() && (this.inventoryHolder.getInventory().getType().name().equalsIgnoreCase(options.getInventoryType()) || SIZEABLE_CONTAINERS.contains(options.getInventoryType().toUpperCase()) && SIZEABLE_CONTAINERS.contains(this.inventoryHolder.getInventory().getType().name()))) {
            this.inventoryHolder.getInventory().clear();
        } else {
            this.inventoryHolder = new StandardInventoryHolder();
        }
        Inventory inventory = SIZEABLE_CONTAINERS.contains(options.getInventoryType().toUpperCase()) ? Bukkit.createInventory((InventoryHolder)this.inventoryHolder, (int)(options.getRenderActualRows() * options.getItemsOnRow()), (String)this.getTitle().toLegacy()) : Bukkit.createInventory((InventoryHolder)this.inventoryHolder, (InventoryType)InventoryType.valueOf((String)options.getInventoryType().toUpperCase()), (String)this.getTitle().toLegacy());
        this.inventoryHolder.setInventoryRenderer(this);
        this.inventoryHolder.setInventory(inventory);
        this.inventoryHolder.setSubInventory(this.subInventory);
        ItemStack emptyItem = options.getEmptySlotItem();
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, emptyItem.as(org.bukkit.inventory.ItemStack.class));
        }
        this.itemStacksInInventory.forEach((position, item) -> {
            if (position < inventory.getSize()) {
                org.bukkit.inventory.ItemStack asStack = item.as(org.bukkit.inventory.ItemStack.class);
                if (!item.getMaterial().isAir()) {
                    inventory.setItem(position.intValue(), asStack);
                }
            }
        });
        this.player.asOptional(Player.class).ifPresent(p -> p.openInventory(inventory));
        if (!this.animations.isEmpty()) {
            this.animator = Tasker.runDelayedAndRepeatedly((ThreadProperty)DefaultThreads.GLOBAL_THREAD, () -> this.animations.forEach((position, items) -> inventory.setItem(position.intValue(), ((ItemStack)items.get(this.nextAnimationPosition % items.size())).as(org.bukkit.inventory.ItemStack.class))), 1L, TaskerTime.TICKS, 20L, TaskerTime.TICKS);
        }
    }

    @Override
    public boolean isOpened() {
        return InventoryUtils.getInventoryHolderWithoutSnapshot(this.player.as(Player.class).getOpenInventory().getTopInventory()) == this.inventoryHolder;
    }

    @Override
    public void close() {
        super.close();
        this.player.closeInventory();
    }
}

