/*
 * Decompiled with CFR 0.152.
 */
package sba.si.placeholders;

import java.util.Objects;
import sba.si.inventory.PlayerItemInfo;
import sba.si.placeholders.PlaceholderParser;
import sba.sl.a.AttributeType;
import sba.sl.pa.Player;

public class PlayerPlaceholderParser
implements PlaceholderParser {
    @Override
    public String processPlaceholder(String key, Player playerWrapper, PlayerItemInfo item, String[] arguments) {
        if (arguments.length >= 1) {
            switch (arguments[0]) {
                case "exp": 
                case "xp": {
                    return Float.toString(playerWrapper.getExp());
                }
                case "level": {
                    return Integer.toString(playerWrapper.getLevel());
                }
                case "displayName": {
                    return playerWrapper.getDisplayName().toLegacy();
                }
                case "tabName": {
                    return playerWrapper.getPlayerListName().toLegacy();
                }
                case "health": {
                    return Double.toString(playerWrapper.getHealth());
                }
                case "maxhealth": {
                    return Double.toString(Objects.requireNonNull(playerWrapper.getAttribute(AttributeType.of("generic.max_health"))).getValue());
                }
                case "isdead": 
                case "dead": {
                    return Boolean.toString(playerWrapper.isDead());
                }
                case "isalive": 
                case "alive": {
                    return Boolean.toString(!playerWrapper.isDead());
                }
                case "food": {
                    return Double.toString(playerWrapper.getFoodLevel());
                }
                case "firsttime": {
                    return Long.toString(playerWrapper.getFirstPlayed());
                }
                case "lasttime": {
                    return Long.toString(playerWrapper.getLastPlayed());
                }
                case "playertime": {
                    return Long.toString(playerWrapper.getPlayerTime());
                }
                case "gamemode": {
                    return playerWrapper.getGameMode().location().path();
                }
            }
        }
        return playerWrapper.getName();
    }
}

