/*
 * Decompiled with CFR 0.152.
 */
package sba.si.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import sba.si.events.SubInventoryOpenEvent;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.InventoryLink;
import sba.si.inventory.InventorySet;
import sba.si.inventory.LocalOptions;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.SubInventory;
import sba.sl.i.ItemStack;
import sba.sl.pa.Player;
import sba.sl.spectator.Component;
import sba.sl.t.task.Task;

public abstract class InventoryRenderer {
    protected final Player player;
    protected SubInventory subInventory;
    protected int page;
    protected final Map<Integer, PlayerItemInfo> itemInfoMap = new HashMap<Integer, PlayerItemInfo>();
    protected final Map<Integer, ItemStack> itemStacksInInventory = new HashMap<Integer, ItemStack>();
    protected final Map<Integer, List<ItemStack>> animations = new HashMap<Integer, List<ItemStack>>();
    protected Task animator;
    protected int nextAnimationPosition = 0;
    protected boolean mainEventCalled = false;

    public InventoryRenderer(Player player, SubInventory subInventory, int page) {
        this.player = player;
        this.subInventory = subInventory;
        this.page = page;
    }

    public boolean nextPage() {
        if (this.subInventory.getHighestPage() > this.page) {
            ++this.page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean previousPage() {
        if (this.page > 0) {
            --this.page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean jumpToPage(int page) {
        if (this.subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean jump(SubInventory subInventory) {
        if (subInventory == null) {
            return false;
        }
        this.subInventory = subInventory;
        this.mainEventCalled = false;
        this.render();
        return true;
    }

    public boolean jump(SubInventory subInventory, int page) {
        if (subInventory == null) {
            return false;
        }
        this.subInventory = subInventory;
        this.mainEventCalled = false;
        this.page = 0;
        if (subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
        }
        this.render();
        return true;
    }

    public boolean jump(InventorySet inventorySet) {
        if (inventorySet == null) {
            return false;
        }
        this.subInventory = inventorySet.getMainSubInventory();
        this.mainEventCalled = false;
        this.render();
        return true;
    }

    public boolean jump(InventorySet inventorySet, int page) {
        if (inventorySet == null) {
            return false;
        }
        this.subInventory = inventorySet.getMainSubInventory();
        this.mainEventCalled = false;
        this.page = 0;
        if (this.subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
        }
        this.render();
        return true;
    }

    public boolean jump(InventoryLink inventoryLink) {
        if (inventoryLink == null) {
            return false;
        }
        Optional<SubInventory> link = inventoryLink.resolve();
        if (link.isEmpty()) {
            return false;
        }
        return this.jump(link.get());
    }

    public void render() {
        this.clear();
        if (!this.mainEventCalled) {
            SubInventoryOpenEvent openInventoryEvent = new SubInventoryOpenEvent(this.player, this.subInventory, this.page);
            this.subInventory.getInventorySet().getEventManager().fireEvent(openInventoryEvent);
            if (openInventoryEvent.isCancelled()) {
                this.close();
                return;
            }
            this.mainEventCalled = true;
        }
        this.generateNewData();
        this.renderOnPlatform();
    }

    public void close() {
        this.clear();
        this.player.closeInventory();
    }

    protected void clear() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.nextAnimationPosition = 0;
        this.itemInfoMap.clear();
        this.itemStacksInInventory.clear();
        this.animations.clear();
    }

    protected Component getTitle() {
        LocalOptions options = this.subInventory.getLocalOptions();
        Component prefix = options.getPrefix();
        if (options.isShowPageNumber()) {
            prefix = prefix.withAppendix((Component)Component.text(" - ")).withAppendix((Component)Component.text(this.page + 1));
        }
        return prefix;
    }

    protected void generateNewData() {
        int i;
        LocalOptions options = this.subInventory.getLocalOptions();
        int size = options.getRenderActualRows() * options.getItemsOnRow();
        for (i = 0; i < options.getItemsOnRow(); ++i) {
            this.safePutStackToInventory(size, options.getRenderHeaderStart() + i, options.getCosmeticItem().clone());
        }
        for (i = 0; i < options.getItemsOnRow(); ++i) {
            this.safePutStackToInventory(size, options.getRenderFooterStart() + i, options.getCosmeticItem().clone());
        }
        if (!this.subInventory.isMain()) {
            this.safePutStackToInventory(size, options.getRenderHeaderStart(), options.getBackItem().clone());
        }
        if (this.page > 0) {
            this.safePutStackToInventory(size, options.getRenderFooterStart(), options.getPageBackItem().clone());
        }
        if (this.subInventory.getHighestPage() > this.page) {
            this.safePutStackToInventory(size, options.getRenderFooterStart() + options.getItemsOnRow() - 1, options.getPageForwardItem().clone());
        }
        this.subInventory.getContents().stream().filter(this::isOnThisPage).forEach(itemInfo -> {
            PlayerItemInfo playerItemInfo = new PlayerItemInfo(this.player, (GenericItemInfo)itemInfo);
            int pos = itemInfo.getPosition() % options.getItemsOnPage() + options.getRenderOffset();
            if (playerItemInfo.isVisible()) {
                this.safePutStackToInventory(size, pos, playerItemInfo.getStack());
                if (this.subInventory.getInventorySet().isAnimationsEnabled() && playerItemInfo.hasAnimation()) {
                    this.animations.put(pos, List.copyOf(playerItemInfo.getAnimation()));
                }
            }
            this.itemInfoMap.put(pos, playerItemInfo);
        });
    }

    protected void safePutStackToInventory(int max, int position, ItemStack stack) {
        if (position >= 0 && position < max) {
            this.itemStacksInInventory.put(position, stack);
        }
    }

    protected boolean isOnThisPage(GenericItemInfo item) {
        LocalOptions options = this.subInventory.getLocalOptions();
        return item.isWritten() && this.page == item.getPosition() / options.getItemsOnPage();
    }

    protected abstract void renderOnPlatform();

    public abstract boolean isOpened();

    public Player getPlayer() {
        return this.player;
    }

    public SubInventory getSubInventory() {
        return this.subInventory;
    }

    public int getPage() {
        return this.page;
    }

    public Map<Integer, PlayerItemInfo> getItemInfoMap() {
        return this.itemInfoMap;
    }

    public Map<Integer, ItemStack> getItemStacksInInventory() {
        return this.itemStacksInInventory;
    }

    public Map<Integer, List<ItemStack>> getAnimations() {
        return this.animations;
    }

    public Task getAnimator() {
        return this.animator;
    }

    public int getNextAnimationPosition() {
        return this.nextAnimationPosition;
    }

    public boolean isMainEventCalled() {
        return this.mainEventCalled;
    }
}

