/*
 * Decompiled with CFR 0.152.
 */
package sba.sl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.DyeColorRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface DyeColor
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.DYE_COLOR) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static DyeColor of(@MinecraftType(value=MinecraftType.Type.DYE_COLOR) @NotNull Object dyeColor) {
        DyeColor result = DyeColor.ofNullable(dyeColor);
        Preconditions.checkNotNullIllegal(result, "Could not find dye color: " + String.valueOf(dyeColor));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static DyeColor ofNullable(@MinecraftType(value=MinecraftType.Type.DYE_COLOR) @Nullable Object dyeColor) {
        if (dyeColor instanceof DyeColor) {
            return (DyeColor)dyeColor;
        }
        return (DyeColor)DyeColorRegistry.getInstance().resolveMapping(dyeColor);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull DyeColor> all() {
        return DyeColorRegistry.getInstance().getRegistryItemStream();
    }
}

