/*
 * Decompiled with CFR 0.152.
 */
package sba.sl;

import io.netty.channel.ChannelFuture;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.pa.Player;
import sba.sl.pa.Sender;
import sba.sl.u.Preconditions;
import sba.sl.u.ProxyType;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.w.World;

@ProvidedService
public abstract class Server {
    @Nullable
    private static Server server;
    @Nullable
    private static Integer PROTOCOL_VERSION;
    @Nullable
    private static Integer DATA_VERSION;

    @ApiStatus.Internal
    public Server() {
        Preconditions.checkArgument(server == null, "Server has been already initialized!");
        server = this;
    }

    public static boolean isServerThread() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isServerThread0();
    }

    @NotNull
    public static String getVersion() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getVersion0();
    }

    @NotNull
    public static String getServerSoftwareVersion() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getServerSoftwareVersion0();
    }

    @NotNull
    public static String getServerSoftwareName() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getServerSoftwareName0();
    }

    public static boolean isVersion(int major, int minor) {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isVersion0(major, minor);
    }

    public static boolean isVersion(int major, int minor, int patch) {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").isVersion0(major, minor, patch);
    }

    @NotNull
    public static @NotNull List<@NotNull Player> getConnectedPlayers() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getConnectedPlayers0();
    }

    @NotNull
    public static @NotNull List<@NotNull Player> getConnectedPlayersFromWorld(@NotNull World world) {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!");
        Preconditions.checkNotNull(world, "Invalid world provided!");
        return server.getConnectedPlayersFromWorld0(world);
    }

    public static void shutdown() {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!").shutdown0();
    }

    @NotNull
    public static ProxyType getProxyType() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getProxyType0();
    }

    @NotNull
    public static Integer getProtocolVersion() {
        if (PROTOCOL_VERSION == null) {
            PROTOCOL_VERSION = Preconditions.checkNotNull(server, "Server has not yet been initialized!").getProtocolVersion0();
        }
        return PROTOCOL_VERSION;
    }

    @NotNull
    public static Integer getDataVersion() {
        if (DATA_VERSION == null) {
            DATA_VERSION = Preconditions.checkNotNull(server, "Server has not yet been initialized!").getDataVersion0();
        }
        return DATA_VERSION;
    }

    @NotNull
    public static Sender getConsoleSender() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getConsoleSender0();
    }

    @LimitedVersionSupport(value=">= 1.20.5; otherwise returns false")
    public static boolean acceptsTransfers() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").acceptsTransfers0();
    }

    @NotNull
    public abstract String getVersion0();

    @NotNull
    public abstract String getServerSoftwareVersion0();

    @NotNull
    public abstract String getServerSoftwareName0();

    public static List<@NotNull ChannelFuture> getConnections() {
        return Preconditions.checkNotNull(server, "Server has not yet been initialized!").getConnections0();
    }

    @LimitedVersionSupport(value="1.8.8; has no effect on any other version")
    public static void preferEnderDragonBossBar(boolean prefer) {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!").preferEnderDragonBossBar0(prefer);
    }

    @LimitedVersionSupport(value="1.8.8; has no effect on any other version")
    public static void enableViaHooksForBossBar(boolean enable) {
        Preconditions.checkNotNull(server, "Server has not yet been initialized!").enableViaHooksForBossBar0(enable);
    }

    protected void preferEnderDragonBossBar0(boolean prefer) {
    }

    protected void enableViaHooksForBossBar0(boolean enable) {
    }

    public abstract boolean isVersion0(int var1, int var2);

    public abstract boolean isVersion0(int var1, int var2, int var3);

    public abstract boolean isServerThread0();

    @NotNull
    public abstract @NotNull List<@NotNull Player> getConnectedPlayers0();

    @NotNull
    public abstract @NotNull List<@NotNull Player> getConnectedPlayersFromWorld0(@NotNull World var1);

    public abstract List<@NotNull ChannelFuture> getConnections0();

    @NotNull
    public abstract Sender getConsoleSender0();

    public abstract void shutdown0();

    @NotNull
    public abstract ProxyType getProxyType0();

    @NotNull
    public abstract Integer getProtocolVersion0();

    @NotNull
    public abstract Integer getDataVersion0();

    public abstract boolean acceptsTransfers0();
}

