/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface CommandSenderHolder
extends Wrapper {
    @NotNull
    public static CommandSenderHolder of(@NotNull Object commandSender) {
        CommandSenderHolder result = CommandSenderHolder.ofNullable(commandSender);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap command sender: " + String.valueOf(commandSender));
        }
        return result;
    }

    @Nullable
    public static CommandSenderHolder ofNullable(@Nullable Object commandSender) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + CommandSenderHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (commandSender == null) {
            return null;
        }
        return Provider.provider.apply(commandSender);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable CommandSenderHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable CommandSenderHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + CommandSenderHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

