/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface PlayerHolder
extends Wrapper {
    @NotNull
    public static PlayerHolder of(@NotNull Object player) {
        PlayerHolder result = PlayerHolder.ofNullable(player);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap player: " + String.valueOf(player));
        }
        return result;
    }

    @Nullable
    public static PlayerHolder ofNullable(@Nullable Object player) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + PlayerHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (player == null) {
            return null;
        }
        return Provider.provider.apply(player);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable PlayerHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable PlayerHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + PlayerHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

