/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface EntityHolder
extends Wrapper {
    @NotNull
    public static EntityHolder of(@NotNull Object entity) {
        EntityHolder result = EntityHolder.ofNullable(entity);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap entity: " + String.valueOf(entity));
        }
        return result;
    }

    @Nullable
    public static EntityHolder ofNullable(@Nullable Object entity) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + EntityHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (entity == null) {
            return null;
        }
        return Provider.provider.apply(entity);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable EntityHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable EntityHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + EntityHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

