/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface LocationHolder
extends Wrapper {
    @NotNull
    public static LocationHolder of(@NotNull Object location) {
        LocationHolder result = LocationHolder.ofNullable(location);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap location: " + String.valueOf(location));
        }
        return result;
    }

    @Nullable
    public static LocationHolder ofNullable(@Nullable Object location) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + LocationHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (location == null) {
            return null;
        }
        return Provider.provider.apply(location);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable LocationHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable LocationHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + LocationHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

