/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.cn;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.ContainerHolder;
import sba.sl.cn.Container;
import sba.sl.cn.type.InventoryType;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
public abstract class ContainerFactory {
    @Nullable
    private static ContainerFactory factory;

    @ApiStatus.Internal
    public ContainerFactory() {
        if (factory != null) {
            throw new UnsupportedOperationException("ContainerFactory is already initialized.");
        }
        factory = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static <C extends Container> C wrapContainer(@Nullable Object container) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.wrapContainer0(container);
    }

    @Nullable
    public abstract <C extends Container> C wrapContainer0(@Nullable Object var1);

    @Contract(value="null -> null")
    @Nullable
    public static <C extends Container> C createContainer(@Nullable InventoryType type) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(type);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <C extends Container> C createContainer(@Nullable InventoryType type, @Nullable Component name) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(type, name);
    }

    @Nullable
    public static <C extends Container> C createContainer(int size) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(size);
    }

    @Nullable
    public static <C extends Container> C createContainer(int size, @Nullable Component name) {
        if (factory == null) {
            throw new UnsupportedOperationException("ContainerFactory is not initialized yet.");
        }
        return factory.createContainer0(size, name);
    }

    @Nullable
    public abstract <C extends Container> C createContainer0(@Nullable InventoryType var1);

    @Nullable
    public abstract <C extends Container> C createContainer0(@Nullable InventoryType var1, @Nullable Component var2);

    @Nullable
    public abstract <C extends Container> C createContainer0(int var1);

    @Nullable
    public abstract <C extends Container> C createContainer0(int var1, @Nullable Component var2);

    static {
        ContainerHolder.Provider.registerProvider(o -> (ContainerHolder)Objects.requireNonNull(Objects.requireNonNull(factory, "ContainerFactory is not initialized yet.").wrapContainer0(o), "Cannot wrap " + String.valueOf(o) + " to Container"));
    }
}

