/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.i.meta.Enchantment;

public class EnchantmentSerializer
implements TypeSerializer<Enchantment> {
    @NotNull
    public static final EnchantmentSerializer INSTANCE = new EnchantmentSerializer();

    @Override
    @NotNull
    public Enchantment deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            if (node.isMap()) {
                String typeNode = node.node("type").getString();
                int levelNode = node.node("level").getInt(1);
                if (typeNode != null && !typeNode.isEmpty()) {
                    return Enchantment.of(typeNode).withLevel(levelNode);
                }
            }
            return Enchantment.of(node.getString());
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Enchantment obj, @NotNull ConfigurationNode node) throws SerializationException {
        node.set(obj == null ? null : obj.type().location().asString() + " " + obj.level());
    }
}

