/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.Server;
import sba.sl.a.ItemAttribute;
import sba.sl.co.ItemTypeSerializer;
import sba.sl.f.FireworkEffect;
import sba.sl.i.HideFlags;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.i.meta.Enchantment;
import sba.sl.i.meta.Potion;
import sba.sl.i.meta.PotionEffect;
import sba.sl.impl.attribute.Attributes;
import sba.sl.impl.item.builder.ShortStackDeserializer;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.nbt.Tag;
import sba.sl.nbt.configurate.TagSerializer;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.u.ConfigurateUtils;
import sba.sl.u.ResourceLocation;

public class ItemStackSerializer
implements TypeSerializer<ItemStack> {
    @NotNull
    public static final ItemStackSerializer INSTANCE = new ItemStackSerializer();
    @NotNull
    private static final SNBTSerializer internalSNBTSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build();
    @NotNull
    private static final String TYPE_KEY = "type";
    @NotNull
    private static final String ID_KEY = "id";
    @NotNull
    private static final String META_KEY = "meta";
    @NotNull
    private static final String TAG_KEY = "tag";
    @NotNull
    private static final String DATA_VERSION_KEY = "DataVersion";
    @NotNull
    private static final String AMOUNT_KEY = "amount";
    @NotNull
    private static final String COUNT_KEY = "count";
    @NotNull
    private static final String DAMAGE_KEY = "damage";
    @NotNull
    private static final String DURABILITY_KEY = "durability";
    @NotNull
    private static final String DISPLAY_NAME_KEY = "display-name";
    @NotNull
    private static final String LOC_NAME_KEY = "loc-name";
    @NotNull
    private static final String CUSTOM_MODEL_DATA_KEY = "custom-model-data";
    @NotNull
    private static final String REPAIR_COST_KEY = "repair-cost";
    @NotNull
    private static final String ITEM_FLAGS_KEY = "ItemFlags";
    @NotNull
    private static final String UNBREAKABLE_KEY = "Unbreakable";
    @NotNull
    private static final String LORE_KEY = "lore";
    @NotNull
    private static final String ENCHANTS_KEY = "enchants";
    @NotNull
    private static final String POTION_TYPE_KEY = "potion-type";
    @NotNull
    private static final String EFFECTS_KEY = "effects";
    @NotNull
    private static final String ATTRIBUTES_KEY = "attributes";
    @NotNull
    private static final String RECIPES_KEY = "recipes";
    @NotNull
    private static final String COLOR_KEY = "color";
    @NotNull
    private static final String FIREWORK_EFFECTS_KEY = "firework-effects";
    @NotNull
    private static final String POWER_KEY = "power";

    @Override
    @NotNull
    public ItemStack deserialize(@NotNull Type classType, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            ConfigurationNode power;
            ConfigurationNode fireworkEffects;
            ConfigurationNode color;
            ConfigurationNode recipes;
            ConfigurationNode attributes;
            ConfigurationNode potionEffects;
            ConfigurationNode potionType;
            ConfigurationNode enchants;
            ConfigurationNode lore;
            ConfigurationNode unbreakable;
            ConfigurationNode itemFlags;
            ConfigurationNode repairCost;
            ConfigurationNode customModelData;
            ConfigurationNode locName;
            ConfigurationNode displayName;
            ConfigurationNode durability;
            ConfigurationNode amount;
            ConfigurationNode meta;
            if (!node.isMap()) {
                ItemStackBuilder builder = ItemStackFactory.builder();
                ShortStackDeserializer.deserializeShortStack(builder, node.getString());
                return Objects.requireNonNull(builder.build());
            }
            ItemStackBuilder builder = ItemStackFactory.builder();
            ConfigurationNode type = node.node(TYPE_KEY);
            if (type.empty()) {
                type = node.node(ID_KEY);
            }
            ShortStackDeserializer.deserializeShortStack(builder, type.getString());
            ConfigurationNode tag = node.node(TAG_KEY);
            if (!tag.empty()) {
                ConfigurationNode dataVersion = node.node(DATA_VERSION_KEY);
                if (tag.isMap()) {
                    Tag nbtTag = TagSerializer.INSTANCE.deserialize((Type)((Object)Tag.class), tag);
                    if (!(nbtTag instanceof CompoundTag)) {
                        throw new IllegalArgumentException("tag should be a compound tag, got " + String.valueOf(nbtTag));
                    }
                    builder.tag((CompoundTag)nbtTag, dataVersion.getInt(0));
                } else {
                    Tag snbtTag = internalSNBTSerializer.deserialize(tag.getString(""));
                    if (!(snbtTag instanceof CompoundTag)) {
                        throw new IllegalArgumentException("tag should be a compound tag, got " + String.valueOf(snbtTag));
                    }
                    builder.tag((CompoundTag)snbtTag, dataVersion.getInt(0));
                }
            }
            if (!(meta = node.node(META_KEY)).empty()) {
                builder.platformMeta(ConfigurateUtils.toMap(meta));
            }
            if (!(amount = node.node(AMOUNT_KEY)).empty()) {
                builder.amount(amount.getInt(1));
            } else {
                ConfigurationNode count = node.node(COUNT_KEY);
                if (!count.empty()) {
                    builder.amount(count.getInt(1));
                }
            }
            ConfigurationNode damage = node.node(DAMAGE_KEY);
            if (!damage.empty()) {
                builder.durability(damage.getInt(0));
            }
            if (!(durability = node.node(DURABILITY_KEY)).empty()) {
                builder.durability(durability.getInt(0));
            }
            if (!(displayName = node.node(DISPLAY_NAME_KEY)).empty()) {
                builder.displayName(Component.fromLegacy(displayName.getString()));
            }
            if (!(locName = node.node(LOC_NAME_KEY)).empty()) {
                builder.localizedName(locName.getString());
            }
            if (!(customModelData = node.node(CUSTOM_MODEL_DATA_KEY)).empty()) {
                try {
                    builder.customModelData(customModelData.get(Integer.class));
                }
                catch (SerializationException serializationException) {
                    // empty catch block
                }
            }
            if (!(repairCost = node.node(REPAIR_COST_KEY)).empty()) {
                builder.repairCost(repairCost.getInt());
            }
            if (!(itemFlags = node.node(ITEM_FLAGS_KEY)).empty()) {
                if (itemFlags.isList()) {
                    try {
                        builder.flags(itemFlags.getList(String.class));
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                } else {
                    builder.hideFlag(HideFlags.convert(itemFlags.getString("")));
                }
            }
            if (!(unbreakable = node.node(UNBREAKABLE_KEY)).empty()) {
                builder.unbreakable(unbreakable.getBoolean(false));
            }
            if (!(lore = node.node(LORE_KEY)).empty()) {
                if (lore.isList()) {
                    try {
                        List<String> list = Objects.requireNonNull(lore.getList(String.class));
                        builder.lore(list);
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                } else {
                    builder.lore(lore.getString());
                }
            }
            if (!(enchants = node.node(ENCHANTS_KEY)).empty()) {
                if (enchants.isMap()) {
                    enchants.childrenMap().entrySet().stream().map(Enchantment::ofNullable).filter(Objects::nonNull).forEach(builder::enchantment);
                } else if (enchants.isList()) {
                    try {
                        enchants.getList(Object.class).stream().map(Enchantment::ofNullable).filter(Objects::nonNull).forEach(builder::enchantment);
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Enchantment enchantment = Enchantment.ofNullable(enchants.get(Object.class));
                        if (enchantment != null) {
                            builder.enchantment(enchantment);
                        }
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!(potionType = node.node(POTION_TYPE_KEY)).empty()) {
                try {
                    Potion potion = Potion.ofNullable(potionType.get(Object.class));
                    if (potion != null) {
                        builder.potion(potion);
                    }
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            }
            if (!(potionEffects = node.node(EFFECTS_KEY)).empty()) {
                if (potionEffects.isList()) {
                    builder.effect(potionEffects.childrenList().stream().map(PotionEffect::ofNullable).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    PotionEffect potionEffect = PotionEffect.ofNullable(potionEffects);
                    if (potionEffect != null) {
                        builder.effect(potionEffect);
                    }
                }
            }
            if (!(attributes = node.node(ATTRIBUTES_KEY)).empty()) {
                if (attributes.isList()) {
                    attributes.childrenList().stream().map(Attributes::wrapItemAttribute).filter(Objects::nonNull).forEach(builder::attributeModifier);
                } else {
                    ItemAttribute itemAttribute = Attributes.wrapItemAttribute(attributes);
                    if (itemAttribute != null) {
                        builder.attributeModifier(itemAttribute);
                    }
                }
            }
            if (!(recipes = node.node(RECIPES_KEY)).empty()) {
                if (recipes.isList()) {
                    attributes.childrenList().stream().map(ConfigurationNode::getString).map(ResourceLocation::ofNullable).filter(Objects::nonNull).forEach(builder::recipe);
                } else {
                    ResourceLocation res = ResourceLocation.ofNullable(recipes.getString());
                    if (res != null) {
                        builder.recipe(res);
                    }
                }
            }
            if (!(color = node.node(COLOR_KEY)).empty()) {
                Color c = Color.hexOrName(color.getString(""));
                builder.color(c);
            }
            if (!(fireworkEffects = node.node(FIREWORK_EFFECTS_KEY)).empty()) {
                if (fireworkEffects.isList()) {
                    builder.fireworkEffect(fireworkEffects.childrenList().stream().map(FireworkEffect::ofNullable).filter(Objects::nonNull).collect(Collectors.toList()));
                } else {
                    FireworkEffect fireworkEffect = FireworkEffect.ofNullable(fireworkEffects);
                    if (fireworkEffect != null) {
                        builder.fireworkEffect(fireworkEffect);
                    }
                }
            }
            if (!(power = node.node(POWER_KEY)).empty()) {
                builder.power(power.getInt());
            }
            return Objects.requireNonNull(builder.build());
        }
        catch (Throwable throwable) {
            throw new SerializationException(throwable);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable ItemStack obj, @NotNull ConfigurationNode node) throws SerializationException {
        node.set(null);
        if (obj != null) {
            ItemTypeSerializer.INSTANCE.serialize((Type)((Object)ItemType.class), obj.getType(), node.node(ID_KEY));
            node.node(COUNT_KEY).set(obj.getAmount());
            CompoundTag tag = obj.getTag();
            if (!tag.isEmpty()) {
                node.node(TAG_KEY).set(internalSNBTSerializer.serialize(tag));
                node.node(DATA_VERSION_KEY).set(Server.getDataVersion());
            }
        }
    }
}

