/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.api.types.server.EntityHolder;
import sba.sl.e.Entity;
import sba.sl.e.ExperienceOrb;
import sba.sl.e.HumanEntity;
import sba.sl.e.ItemEntity;
import sba.sl.e.LightningBolt;
import sba.sl.e.LivingEntity;
import sba.sl.e.Mob;
import sba.sl.e.projectile.FireworkRocket;
import sba.sl.e.projectile.ProjectileEntity;
import sba.sl.e.type.EntityType;
import sba.sl.i.ItemStack;
import sba.sl.impl.entity.type.EntityTypeRegistry;
import sba.sl.impl.item.meta.PotionEffectRegistry;
import sba.sl.impl.world.Locations;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.w.Location;

@ProvidedService
@ServiceDependencies(dependsOn={EntityTypeRegistry.class, Locations.class, PotionEffectRegistry.class})
public abstract class Entities {
    @Nullable
    private static Entities mapper;

    @ApiStatus.Internal
    public Entities() {
        if (mapper != null) {
            throw new UnsupportedOperationException("EntityMapper is already initialized");
        }
        mapper = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Entity wrapEntity(@Nullable Object entity) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        if (entity == null) {
            return null;
        }
        if (entity instanceof Entity) {
            return (Entity)entity;
        }
        return mapper.wrapEntity0(entity);
    }

    @Contract(value="null -> null")
    @Nullable
    public static ExperienceOrb wrapEntityExperience(@Nullable Object entity) {
        Entity entityExperience = Entities.wrapEntity(entity);
        if (entityExperience instanceof ExperienceOrb) {
            return (ExperienceOrb)entityExperience;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static FireworkRocket wrapEntityFirework(@Nullable Object entity) {
        Entity entityFirework = Entities.wrapEntity(entity);
        if (entityFirework instanceof FireworkRocket) {
            return (FireworkRocket)entityFirework;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static HumanEntity wrapEntityHuman(@Nullable Object entity) {
        Entity entityHuman = Entities.wrapEntity(entity);
        if (entityHuman instanceof HumanEntity) {
            return (HumanEntity)entityHuman;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ItemEntity wrapEntityItem(@Nullable Object entity) {
        Entity entityItem = Entities.wrapEntity(entity);
        if (entityItem instanceof ItemEntity) {
            return (ItemEntity)entityItem;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static LightningBolt wrapEntityLightning(@Nullable Object entity) {
        Entity entityLightning = Entities.wrapEntity(entity);
        if (entityLightning instanceof LightningBolt) {
            return (LightningBolt)entityLightning;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static LivingEntity wrapEntityLiving(@Nullable Object entity) {
        Entity entityLiving = Entities.wrapEntity(entity);
        if (entityLiving instanceof LivingEntity) {
            return (LivingEntity)entityLiving;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Mob wrapEntityPathfindingMob(@Nullable Object entity) {
        Entity entityPathfindingMob = Entities.wrapEntity(entity);
        if (entityPathfindingMob instanceof Mob) {
            return (Mob)entityPathfindingMob;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ProjectileEntity wrapEntityProjectile(@Nullable Object entity) {
        Entity entityProjectile = Entities.wrapEntity(entity);
        if (entityProjectile instanceof ProjectileEntity) {
            return (ProjectileEntity)entityProjectile;
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static Entity spawn(@Nullable Object entityType, @NotNull Location locationHolder) {
        if (entityType == null) {
            return null;
        }
        if (entityType instanceof EntityType) {
            return Entities.spawn((EntityType)entityType, locationHolder);
        }
        EntityType type = EntityType.ofNullable(entityType);
        if (type != null) {
            return Entities.spawn(type, locationHolder);
        }
        return null;
    }

    @Nullable
    public static Entity spawn(@NotNull EntityType entityType, @NotNull Location locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.spawn0(entityType, locationHolder, null);
    }

    @Nullable
    public static Entity spawn(@Nullable Object entityType, @NotNull Location locationHolder, @Nullable Consumer<? super @NotNull Entity> preSpawnFunction) {
        EntityType type = EntityType.ofNullable(entityType);
        return type != null ? Entities.spawn(type, locationHolder, preSpawnFunction) : null;
    }

    @Nullable
    public static Entity spawn(@NotNull EntityType entityType, @NotNull Location locationHolder, @Nullable Consumer<? super @NotNull Entity> preSpawnFunction) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.spawn0(entityType, locationHolder, preSpawnFunction);
    }

    @Nullable
    public static ItemEntity dropItem(@NotNull ItemStack item, @NotNull Location locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropItem0(item, locationHolder, null);
    }

    @Nullable
    public static ItemEntity dropItem(@NotNull ItemStack item, @NotNull Location locationHolder, @Nullable Consumer<? super @NotNull ItemEntity> preSpawnFunction) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropItem0(item, locationHolder, preSpawnFunction);
    }

    @Nullable
    public static ExperienceOrb dropExperience(int experience, @NotNull Location locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropExperience0(experience, locationHolder, null);
    }

    @Nullable
    public static ExperienceOrb dropExperience(int experience, @NotNull Location locationHolder, @Nullable Consumer<? super @NotNull ExperienceOrb> preSpawnFunction) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.dropExperience0(experience, locationHolder, preSpawnFunction);
    }

    @Nullable
    public static LightningBolt strikeLightning(@NotNull Location locationHolder) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.strikeLightning0(locationHolder, null);
    }

    @Nullable
    public static LightningBolt strikeLightning(@NotNull Location locationHolder, @Nullable Consumer<? super @NotNull LightningBolt> preSpawnFunction) {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.strikeLightning0(locationHolder, preSpawnFunction);
    }

    public static int getNewEntityId() {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        if (!Server.isServerThread()) {
            throw new UnsupportedOperationException("EntityMapper#getNewEntityId() method must be called from the Server thread!, or use EntityMapper#getNewEntityIdSynchronously() instead");
        }
        return mapper.getNewEntityId0();
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull Integer> getNewEntityIdSynchronously() {
        if (mapper == null) {
            throw new UnsupportedOperationException("EntityMapper is not initialized yet.");
        }
        return mapper.getNewEntityIdSynchronously0();
    }

    @Nullable
    protected abstract Entity wrapEntity0(@NotNull Object var1);

    @Nullable
    public abstract Entity spawn0(@NotNull EntityType var1, @NotNull Location var2, @Nullable Consumer<? super @NotNull Entity> var3);

    @Nullable
    public abstract ItemEntity dropItem0(@NotNull ItemStack var1, @NotNull Location var2, @Nullable Consumer<? super @NotNull ItemEntity> var3);

    @Nullable
    public abstract ExperienceOrb dropExperience0(int var1, @NotNull Location var2, @Nullable Consumer<? super @NotNull ExperienceOrb> var3);

    @Nullable
    public abstract LightningBolt strikeLightning0(@NotNull Location var1, @Nullable Consumer<? super @NotNull LightningBolt> var2);

    public abstract int getNewEntityId0();

    @NotNull
    public abstract @NotNull CompletableFuture<@NotNull Integer> getNewEntityIdSynchronously0();

    static {
        EntityHolder.Provider.registerProvider(o -> Objects.requireNonNull(Entities.wrapEntity(o), "Cannot wrap " + String.valueOf(o) + " to Entity"));
    }
}

