/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.Attribute;
import sba.sl.a.AttributeType;
import sba.sl.b.Block;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entity;
import sba.sl.e.HumanEntity;
import sba.sl.e.projectile.ProjectileShooter;
import sba.sl.i.ItemStack;
import sba.sl.i.meta.PotionEffect;
import sba.sl.w.Location;

public interface LivingEntity
extends Entity,
ProjectileShooter {
    @Nullable
    public Attribute getAttribute(@NotNull AttributeType var1);

    @NotNull
    default public Attribute getOrCreateAttribute(@NotNull AttributeType attributeType) {
        return this.getOrCreateAttribute(attributeType, 0.0);
    }

    @NotNull
    public Attribute getOrCreateAttribute(@NotNull AttributeType var1, double var2);

    public double getEyeHeight();

    public double getEyeHeight(boolean var1);

    @NotNull
    public Location getEyeLocation();

    @NotNull
    public BlockPlacement getTargetBlock(@Nullable Collection<@NotNull Block> var1, int var2);

    @Nullable
    public BlockPlacement getTargetBlock(int var1);

    public int getRemainingAir();

    public void setRemainingAir(int var1);

    public int getMaximumAir();

    public void setMaximumAir(int var1);

    public int getArrowCooldown();

    public void setArrowCooldown(int var1);

    public int getArrowsInBody();

    public void setArrowsInBody(int var1);

    public int getMaximumNoDamageTicks();

    public void setMaximumNoDamageTicks(int var1);

    public double getLastDamage();

    public void setLastDamage(double var1);

    public int getNoDamageTicks();

    public void setNoDamageTicks(int var1);

    @Nullable
    public HumanEntity getHumanKiller();

    public boolean addPotionEffect(@NotNull PotionEffect var1);

    public boolean addPotionEffects(@NotNull @NotNull Collection<@NotNull PotionEffect> var1);

    public boolean hasPotionEffect(@NotNull PotionEffect var1);

    public void removePotionEffect(@NotNull PotionEffect var1);

    @NotNull
    public @NotNull List<@NotNull PotionEffect> getActivePotionEffects();

    public boolean getRemoveWhenFarAway();

    public void setRemoveWhenFarAway(boolean var1);

    public void setCanPickupItems(boolean var1);

    public boolean getCanPickupItems();

    public boolean isLeashed();

    @Nullable
    public Entity getLeashHolder();

    public boolean setLeashHolder(@Nullable Entity var1);

    public boolean removeLeashHolder();

    public boolean isGliding();

    public void setGliding(boolean var1);

    public boolean isSwimming();

    public void setSwimming(boolean var1);

    public boolean isRiptiding();

    public boolean isSleeping();

    public void setAI(boolean var1);

    public boolean hasAI();

    public void attack(@NotNull Entity var1);

    public void swingMainHand();

    public void swingOffHand();

    public void setCollidable(boolean var1);

    public boolean isCollidable();

    public void setInvisible(boolean var1);

    public boolean isInvisible();

    public void damage(double var1);

    public void damage(double var1, @Nullable Entity var3);

    public double getAbsorptionAmount();

    public double getHealth();

    public void setAbsorptionAmount(double var1);

    public void setHealth(double var1);

    @Nullable
    public ItemStack getHelmet();

    @Nullable
    public ItemStack getChestplate();

    @Nullable
    public ItemStack getLeggings();

    @Nullable
    public ItemStack getBoots();

    public void setHelmet(@Nullable ItemStack var1);

    public void setChestplate(@Nullable ItemStack var1);

    public void setLeggings(@Nullable ItemStack var1);

    public void setBoots(@Nullable ItemStack var1);

    @Nullable
    public ItemStack getItemInMainHand();

    public void setItemInMainHand(@Nullable ItemStack var1);

    @Nullable
    public ItemStack getItemInOffHand();

    public void setItemInOffHand(@Nullable ItemStack var1);

    @Nullable
    default public LivingEntity getTarget() {
        return this.getTarget(3);
    }

    @Nullable
    default public LivingEntity getTarget(int radius) {
        for (LivingEntity e : this.getLocation().getNearbyEntitiesByClass(LivingEntity.class, radius)) {
            Location eye = this.getEyeLocation();
            double dot = e.getLocation().asVector().subtract(eye.asVector()).normalize().dot(eye.getFacingDirection());
            if (!(dot > 0.99)) continue;
            return e;
        }
        return null;
    }
}

