/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e.type;

import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.TaggableHolder;
import sba.sl.api.types.server.EntityTypeHolder;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.entity.type.EntityTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;
import sba.sl.w.Location;

public interface EntityType
extends RegistryItem,
RawValueHolder,
TaggableHolder,
EntityTypeHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    public boolean isAlive();

    @Override
    public boolean hasTag(@MinecraftType(value=MinecraftType.Type.ENTITY_TYPE_TAG) @NotNull Object var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ENTITY_TYPE_OR_TAG) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @Nullable
    default public Entity spawn(@NotNull Location location) {
        return this.spawn(location, null);
    }

    @Nullable
    default public Entity spawn(@NotNull Location location, @Nullable Consumer<? super @NotNull Entity> preSpawnFunction) {
        return Entities.spawn(this, location, preSpawnFunction);
    }

    @NotNull
    public static EntityType of(@MinecraftType(value=MinecraftType.Type.ENTITY_TYPE) @NotNull Object entityType) {
        EntityType result = EntityType.ofNullable(entityType);
        Preconditions.checkNotNullIllegal(result, "Could not find entity type: " + String.valueOf(entityType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static EntityType ofNullable(@MinecraftType(value=MinecraftType.Type.ENTITY_TYPE) @Nullable Object entityType) {
        if (entityType instanceof EntityType) {
            return (EntityType)entityType;
        }
        return (EntityType)EntityTypeRegistry.getInstance().resolveMapping(entityType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull EntityType> all() {
        return EntityTypeRegistry.getInstance().getRegistryItemStream();
    }
}

