/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.h;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.h.Hologram;
import sba.sl.h.HologramManager;
import sba.sl.h.piece.ArmorStandHologramPiece;
import sba.sl.h.piece.HologramPiece;
import sba.sl.h.piece.TextDisplayHologramPiece;
import sba.sl.i.ItemStack;
import sba.sl.impl.utils.feature.PlatformFeature;
import sba.sl.impl.utils.visual.SimpleCLTextEntry;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundRemoveEntitiesPacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.ClientboundSetEquipmentPacket;
import sba.sl.p.entity.FakeEntity;
import sba.sl.pa.Player;
import sba.sl.sl.EquipmentSlot;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.t.task.Task;
import sba.sl.u.Pair;
import sba.sl.u.data.DataContainer;
import sba.sl.u.math.Vector3Df;
import sba.sl.vi.UpdateStrategy;
import sba.sl.vi.impl.AbstractLinedVisual;
import sba.sl.w.Location;

public class HologramImpl
extends AbstractLinedVisual<Hologram>
implements Hologram {
    @NotNull
    public static final PlatformFeature DISPLAY_ENTITIES_AVAILABLE = PlatformFeature.of(() -> Server.isVersion(1, 19, 4));
    @NotNull
    private final @NotNull Map<@NotNull Integer, HologramPiece> entitiesOnLines;
    @Nullable
    private volatile ArmorStandHologramPiece itemEntity;
    @Nullable
    private volatile Task rotationTask;
    @NotNull
    private Location cachedLocation;
    @NotNull
    private Location location;
    private int viewDistance;
    private boolean touchable;
    private boolean created;
    @Nullable
    private DataContainer data;
    private float rotationIncrement;
    @NotNull
    private @NotNull Pair<@NotNull Integer, @NotNull TaskerTime> rotationTime;
    @NotNull
    private Hologram.RotationMode rotationMode;
    @Nullable
    private ItemStack item;
    @NotNull
    private Hologram.ItemPosition itemPosition;
    private long clickCooldown;

    public HologramImpl(@NotNull UUID uuid, @NotNull Location location, boolean touchable) {
        super(uuid);
        this.location = location;
        this.touchable = touchable;
        this.clickCooldown = 20L;
        this.viewDistance = 4096;
        this.rotationIncrement = 10.0f;
        this.data = DataContainer.get();
        this.rotationTime = Pair.of(2, TaskerTime.TICKS);
        this.rotationMode = Hologram.RotationMode.NONE;
        this.itemPosition = Hologram.ItemPosition.ABOVE;
        this.entitiesOnLines = new ConcurrentHashMap<Integer, HologramPiece>();
        this.cachedLocation = location;
    }

    @Override
    @NotNull
    public Hologram location(@NotNull Location location) {
        this.location = location;
        this.cachedLocation = location;
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public Hologram spawn() {
        if (this.created) {
            throw new UnsupportedOperationException("Hologram has already been spawned!");
        }
        this.show();
        this.created = true;
        return this;
    }

    @Override
    public boolean hasId(int entityId) {
        return this.entitiesOnLines.values().stream().anyMatch(entity -> entity.getId() == entityId);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public Hologram update(@NotNull UpdateStrategy strategy) {
        if (this.visible) {
            this.updateEntities();
        }
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public Hologram show() {
        if (this.destroyed()) {
            throw new UnsupportedOperationException("Cannot call Hologram#show() on destroyed holograms!");
        }
        this.visible = true;
        this.update();
        this.startRotationTask();
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public Hologram hide() {
        if (!this.shown()) {
            return this;
        }
        this.visible = false;
        this.viewers.forEach(viewer -> this.onViewerRemoved((Player)viewer, false));
        this.cancelRotationTask();
        return this;
    }

    @Override
    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    @Override
    @NotNull
    public Hologram rotationTime(@NotNull @NotNull Pair<@NotNull Integer, @NotNull TaskerTime> rotationTime) {
        this.rotationTime = rotationTime;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    @NotNull
    public Hologram rotationMode(@NotNull Hologram.RotationMode mode) {
        this.rotationMode = mode;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    @NotNull
    public Hologram item(@Nullable ItemStack item) {
        this.item = item;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    @NotNull
    public Hologram itemPosition(@NotNull Hologram.ItemPosition location) {
        this.itemPosition = location;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    public void destroy() {
        if (this.destroyed()) {
            return;
        }
        this.hide();
        this.viewers.clear();
        this.visible = false;
        this.destroyed = true;
        this.data = null;
        HologramManager.removeHologram(this);
    }

    @Override
    public void onViewerAdded(@NotNull Player viewer, boolean checkDistance) {
        if (!viewer.isOnline()) {
            return;
        }
        if (this.visible && this.entitiesOnLines.size() != this.lines.size()) {
            this.updateEntities();
        }
        this.update(viewer, this.getAllSpawnPackets(viewer), checkDistance);
    }

    @Override
    public void onViewerRemoved(@NotNull Player viewer, boolean checkDistance) {
        if (!viewer.isOnline()) {
            return;
        }
        ArrayList<AbstractPacket> toSend = new ArrayList<AbstractPacket>();
        if (this.itemEntity != null || !this.entitiesOnLines.isEmpty()) {
            toSend.add(this.getFullDestroyPacket());
            this.update(viewer, toSend, false);
        }
    }

    private void update(Player player, @NotNull @NotNull List<@NotNull AbstractPacket> packets, boolean checkDistance) {
        if (!player.getLocation().getWorld().equals(this.cachedLocation.getWorld())) {
            return;
        }
        if (checkDistance && player.getLocation().getDistanceSquared(this.cachedLocation) >= (double)this.viewDistance) {
            return;
        }
        packets.forEach(packet -> packet.sendPacket(player));
    }

    private void updateEntities() {
        LinkedList<Function<Player, List>> packets = new LinkedList<Function<Player, List>>();
        if (this.visible && !this.viewers.isEmpty()) {
            if (this.lines.size() != this.originalLinesSize.intValue() && this.itemEntity != null) {
                this.itemEntity.setLocation(this.cachedLocation.clone().add(0.0, this.itemPosition == Hologram.ItemPosition.BELOW ? (double)(-this.lines.size()) * 0.25 - 0.5 : (double)this.lines.size() * 0.25, 0.0));
                packets.add(p -> List.of(this.itemEntity.getTeleportPacket()));
            }
            this.lines.forEach((key, value) -> {
                try {
                    boolean isSenderMessage;
                    boolean bl = isSenderMessage = value instanceof SimpleCLTextEntry && ((SimpleCLTextEntry)value).getComponentLike() instanceof AudienceComponentLike;
                    if (this.entitiesOnLines.containsKey(key)) {
                        HologramPiece entityOnLine = this.entitiesOnLines.get(key);
                        if (this.originalLinesSize.intValue() == this.lines.size() && (isSenderMessage ? entityOnLine.getAudienceComponent() != null && entityOnLine.getAudienceComponent().equals(((SimpleCLTextEntry)value).getComponentLike()) : entityOnLine.getText() != null && entityOnLine.getText().equals(value.getText()))) {
                            return;
                        }
                        entityOnLine.setText(value.getText(), isSenderMessage ? (AudienceComponentLike)((SimpleCLTextEntry)value).getComponentLike() : null);
                        packets.add(p -> List.of(entityOnLine.getMetadataPacket((Player)p)));
                        entityOnLine.setLocation(this.cachedLocation.clone().add(0.0, (double)(this.lines.size() - key) * 0.25, 0.0));
                        packets.add(p -> List.of(entityOnLine.getTeleportPacket()));
                    } else {
                        FakeEntity piece;
                        Location newLocation = this.cachedLocation.clone().add(0.0, (double)(this.lines.size() - key) * 0.25, 0.0);
                        if (!this.touchable && HologramManager.isPreferDisplayEntities() && DISPLAY_ENTITIES_AVAILABLE.isSupported()) {
                            piece = new TextDisplayHologramPiece(newLocation);
                        } else {
                            ArmorStandHologramPiece entity = new ArmorStandHologramPiece(newLocation);
                            entity.setCustomNameVisible(true);
                            entity.setInvisible(true);
                            entity.setSmall(!this.touchable);
                            entity.setArms(false);
                            entity.setBasePlate(false);
                            entity.setGravity(false);
                            entity.setMarker(!this.touchable);
                            piece = entity;
                        }
                        piece.setText(value.getText(), isSenderMessage ? (AudienceComponentLike)((SimpleCLTextEntry)value).getComponentLike() : null);
                        packets.add(((HologramPiece)((Object)piece))::getSpawnPackets);
                        this.entitiesOnLines.put((Integer)key, (HologramPiece)((Object)piece));
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            });
            try {
                if (this.rotationMode != Hologram.RotationMode.NONE && this.itemEntity == null && this.item != null) {
                    Location newLocation = this.cachedLocation.clone().add(0.0, this.itemPosition == Hologram.ItemPosition.BELOW ? (double)(-this.lines.size()) * 0.25 - 0.5 : (double)this.lines.size() * 0.25, 0.0);
                    ArmorStandHologramPiece entity = new ArmorStandHologramPiece(newLocation);
                    entity.setInvisible(true);
                    entity.setSmall(!this.touchable);
                    entity.setArms(false);
                    entity.setBasePlate(false);
                    entity.setGravity(false);
                    entity.setMarker(!this.touchable);
                    packets.add(entity::getSpawnPackets);
                    packets.add(p -> List.of(this.getEquipmentPacket(entity, this.item)));
                    this.itemEntity = entity;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            int[] arr;
            LinkedList toRemove = new LinkedList();
            if (this.entitiesOnLines.size() > this.lines.size()) {
                this.entitiesOnLines.forEach((key, value) -> {
                    if (!this.lines.containsKey(key)) {
                        toRemove.add(value.getId());
                    }
                });
            }
            if ((arr = toRemove.stream().mapToInt(i -> i).toArray()) != null && arr.length > 0) {
                ClientboundRemoveEntitiesPacket.ClientboundRemoveEntitiesPacketBuilder destroyPacket = ClientboundRemoveEntitiesPacket.builder();
                destroyPacket.entityIds(toRemove.stream().mapToInt(i -> i).toArray());
                packets.add(p -> List.of(destroyPacket.build()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.viewers.forEach(viewer -> this.update((Player)viewer, packets.stream().map(f -> (List)f.apply(viewer)).flatMap(Collection::stream).collect(Collectors.toList()), true));
    }

    private ClientboundSetEquipmentPacket getEquipmentPacket(@NotNull ArmorStandHologramPiece entity, @NotNull ItemStack item) {
        return ClientboundSetEquipmentPacket.builder().entityId(entity.getId()).slots(Map.of(EquipmentSlot.of("HEAD"), item)).build();
    }

    private ClientboundRemoveEntitiesPacket getFullDestroyPacket() {
        Stream<Integer> lines = this.entitiesOnLines.values().stream().map(HologramPiece::getId);
        int[] toRemove = this.itemEntity != null ? Stream.concat(lines, Stream.of(Integer.valueOf(this.itemEntity.getId()))).mapToInt(i -> i).toArray() : lines.mapToInt(i -> i).toArray();
        return ClientboundRemoveEntitiesPacket.builder().entityIds(toRemove).build();
    }

    @NotNull
    private @NotNull List<@NotNull AbstractPacket> getAllSpawnPackets(@NotNull Player viewer) {
        ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
        this.entitiesOnLines.forEach((line, entity) -> packets.addAll(entity.getSpawnPackets(viewer)));
        if (this.itemEntity != null && this.item != null) {
            packets.addAll(this.itemEntity.getSpawnPackets());
            packets.add(this.getEquipmentPacket(this.itemEntity, this.item));
        }
        return packets;
    }

    @NotNull
    private Vector3Df checkAndAdd(@NotNull Vector3Df in) {
        Vector3Df toReturn = new Vector3Df();
        switch (this.rotationMode) {
            case X: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                break;
            }
            case Y: {
                toReturn.setY(this.checkAndIncrement(in.getY()));
                break;
            }
            case Z: {
                toReturn.setZ(this.checkAndIncrement(in.getZ()));
                break;
            }
            case XY: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                toReturn.setY(this.checkAndIncrement(in.getY()));
                break;
            }
            case ALL: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                toReturn.setY(this.checkAndIncrement(in.getY()));
                toReturn.setZ(this.checkAndIncrement(in.getZ()));
            }
        }
        return toReturn;
    }

    private float checkAndIncrement(float in) {
        if (in >= 370.0f) {
            return 0.0f;
        }
        return in + this.rotationIncrement;
    }

    private void startRotationTask() {
        if (this.rotationMode != Hologram.RotationMode.NONE && this.rotationTask == null) {
            this.rotationTask = Tasker.runAsyncRepeatedly(() -> {
                if (this.itemEntity == null || !this.visible) {
                    return;
                }
                this.itemEntity.setHeadRotation(this.checkAndAdd(this.itemEntity.getHeadRotation()));
                ClientboundSetEntityDataPacket metadataPacket = this.itemEntity.getMetadataPacket();
                this.viewers.forEach(player -> this.update((Player)player, List.of(metadataPacket), false));
            }, (long)this.rotationTime.getFirst().intValue(), this.rotationTime.getSecond());
        }
    }

    private void cancelRotationTask() {
        if (this.rotationTask != null && this.rotationTask.isScheduledOrRunning()) {
            this.rotationTask.cancel();
            this.rotationTask = null;
        }
    }

    private void restartRotationTask() {
        this.cancelRotationTask();
        this.startRotationTask();
    }

    @Nullable
    @Generated
    public Task rotationTask() {
        return this.rotationTask;
    }

    @NotNull
    @Generated
    public Location cachedLocation() {
        return this.cachedLocation;
    }

    @Override
    @NotNull
    @Generated
    public Location location() {
        return this.location;
    }

    @Override
    @Generated
    public int viewDistance() {
        return this.viewDistance;
    }

    @Override
    @Generated
    public boolean touchable() {
        return this.touchable;
    }

    @Override
    @Generated
    public boolean created() {
        return this.created;
    }

    @Override
    @Nullable
    @Generated
    public DataContainer data() {
        return this.data;
    }

    @Generated
    public float rotationIncrement() {
        return this.rotationIncrement;
    }

    @Override
    @NotNull
    @Generated
    public @NotNull Pair<@NotNull Integer, @NotNull TaskerTime> rotationTime() {
        return this.rotationTime;
    }

    @Override
    @NotNull
    @Generated
    public Hologram.RotationMode rotationMode() {
        return this.rotationMode;
    }

    @Nullable
    @Generated
    public ItemStack item() {
        return this.item;
    }

    @Override
    @NotNull
    @Generated
    public Hologram.ItemPosition itemPosition() {
        return this.itemPosition;
    }

    @Override
    @Generated
    public long clickCooldown() {
        return this.clickCooldown;
    }

    @Generated
    public HologramImpl itemEntity(@Nullable ArmorStandHologramPiece itemEntity) {
        this.itemEntity = itemEntity;
        return this;
    }

    @Generated
    public HologramImpl rotationTask(@Nullable Task rotationTask) {
        this.rotationTask = rotationTask;
        return this;
    }

    @Generated
    public HologramImpl cachedLocation(@NotNull Location cachedLocation) {
        if (cachedLocation == null) {
            throw new NullPointerException("cachedLocation is marked non-null but is null");
        }
        this.cachedLocation = cachedLocation;
        return this;
    }

    @Override
    @Generated
    public HologramImpl viewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        return this;
    }

    @Override
    @Generated
    public HologramImpl touchable(boolean touchable) {
        this.touchable = touchable;
        return this;
    }

    @Generated
    public HologramImpl created(boolean created) {
        this.created = created;
        return this;
    }

    @Override
    @Generated
    public HologramImpl data(@Nullable DataContainer data) {
        this.data = data;
        return this;
    }

    @Override
    @Generated
    public HologramImpl rotationIncrement(float rotationIncrement) {
        this.rotationIncrement = rotationIncrement;
        return this;
    }

    @Override
    @Generated
    public HologramImpl clickCooldown(long clickCooldown) {
        this.clickCooldown = clickCooldown;
        return this;
    }
}

