/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.hi;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import sba.sl.Core;
import sba.sl.ev.OnEvent;
import sba.sl.ev.player.PlayerLeaveEvent;
import sba.sl.hi.HealthIndicator2;
import sba.sl.hi.HealthIndicatorImpl2;
import sba.sl.p.PacketMapper;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPreDisable;
import sba.sl.vi.Visual;

@Service
@ServiceDependencies(dependsOn={Core.class, PacketMapper.class})
public class HealthIndicatorManager2 {
    private static HealthIndicatorManager2 manager;
    protected final Map<UUID, HealthIndicator2> activeIndicators = new HashMap<UUID, HealthIndicator2>();

    @ApiStatus.Internal
    public HealthIndicatorManager2() {
        if (manager != null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is already initialized!");
        }
        manager = this;
    }

    public static Map<UUID, HealthIndicator2> getActiveIndicators() {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        return Map.copyOf(HealthIndicatorManager2.manager.activeIndicators);
    }

    public static Optional<HealthIndicator2> getHealthIndicator(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        return Optional.ofNullable(HealthIndicatorManager2.manager.activeIndicators.get(uuid));
    }

    public static void addHealthIndicator(HealthIndicator2 healthIndicator) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicatorManager2.manager.activeIndicators.put(healthIndicator.uuid(), healthIndicator);
    }

    public static void removeHealthIndicator(UUID uuid) {
        HealthIndicatorManager2.getHealthIndicator(uuid).ifPresent(HealthIndicatorManager2::removeHealthIndicator);
    }

    public static void removeHealthIndicator(HealthIndicator2 healthIndicator) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicatorManager2.manager.activeIndicators.remove(healthIndicator.uuid());
    }

    public static HealthIndicator2 healthIndicator() {
        return HealthIndicatorManager2.healthIndicator(UUID.randomUUID());
    }

    public static HealthIndicator2 healthIndicator(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HealthIndicatorManager is not initialized yet!");
        }
        HealthIndicator2 healthIndicator = manager.healthIndicator0(uuid);
        HealthIndicatorManager2.addHealthIndicator(healthIndicator);
        return healthIndicator;
    }

    protected HealthIndicator2 healthIndicator0(UUID uuid) {
        return new HealthIndicatorImpl2(uuid);
    }

    @OnPreDisable
    public void destroy() {
        HealthIndicatorManager2.getActiveIndicators().values().forEach(Visual::destroy);
        HealthIndicatorManager2.manager.activeIndicators.clear();
    }

    @OnEvent
    public void onLeave(PlayerLeaveEvent event) {
        if (this.activeIndicators.isEmpty()) {
            return;
        }
        HealthIndicatorManager2.getActiveIndicators().forEach((key, indicator) -> {
            if (indicator.viewers().contains(event.player())) {
                indicator.removeViewer(event.player());
                indicator.removeTrackedPlayer(event.player());
            }
            if (!indicator.hasViewers()) {
                HealthIndicatorManager2.removeHealthIndicator(indicator);
            }
        });
    }
}

