/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.TaggableHolder;
import sba.sl.api.types.server.ItemTypeHolder;
import sba.sl.b.Block;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.pa.ParticleData;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface ItemType
extends RegistryItem,
ParticleData,
TaggableHolder,
ItemTypeHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    default public boolean isAir() {
        return this.equals(ItemType.air());
    }

    public int maxStackSize();

    @NotNull
    default public ItemType colorize(@NotNull String color) {
        return ItemTypeRegistry.colorize(this, color);
    }

    @Nullable
    public Block block();

    @Override
    public boolean hasTag(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE_TAG) @NotNull Object var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE_OR_TAG) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static ItemType of(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @NotNull Object type) {
        ItemType result = ItemType.ofNullable(type);
        Preconditions.checkNotNullIllegal(result, "Could not find item type: " + String.valueOf(type));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ItemType ofNullable(@MinecraftType(value=MinecraftType.Type.ITEM_TYPE) @Nullable Object type) {
        if (type instanceof ItemType) {
            return (ItemType)type;
        }
        return (ItemType)ItemTypeRegistry.getInstance().resolveMapping(type);
    }

    @NotNull
    public static ItemType air() {
        return ItemTypeRegistry.getCachedAir();
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull ItemType> all() {
        return ItemTypeRegistry.getInstance().getRegistryItemStream();
    }
}

