/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.meta;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.impl.item.meta.EnchantmentRegistry;
import sba.sl.u.ComparableWrapper;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;

public interface Enchantment
extends ComparableWrapper,
RawValueHolder {
    @NotNull
    public EnchantmentType type();

    public int level();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Enchantment withLevel(int var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static Enchantment of(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT) @NotNull Object enchantment) {
        Enchantment result = Enchantment.ofNullable(enchantment);
        Preconditions.checkNotNullIllegal(result, "Could not find enchantment: " + String.valueOf(enchantment));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Enchantment ofNullable(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT) @Nullable Object enchantment) {
        if (enchantment instanceof Enchantment) {
            return (Enchantment)enchantment;
        }
        return EnchantmentRegistry.resolve(enchantment);
    }
}

