/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.meta;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.Enchantment;
import sba.sl.impl.item.meta.EnchantmentTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface EnchantmentType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Contract(pure=true)
    @NotNull
    default public Enchantment asEnchantment() {
        return this.asEnchantment(1);
    }

    @Contract(pure=true)
    @NotNull
    public Enchantment asEnchantment(int var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static EnchantmentType of(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT_TYPE) @NotNull Object enchantmentType) {
        EnchantmentType result = EnchantmentType.ofNullable(enchantmentType);
        Preconditions.checkNotNullIllegal(result, "Could not find enchantment type: " + String.valueOf(enchantmentType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static EnchantmentType ofNullable(@MinecraftType(value=MinecraftType.Type.ENCHANTMENT_TYPE) @Nullable Object enchantmentType) {
        if (enchantmentType instanceof EnchantmentType) {
            return (EnchantmentType)enchantmentType;
        }
        return (EnchantmentType)EnchantmentTypeRegistry.getInstance().resolveMapping(enchantmentType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull EnchantmentType> all() {
        return EnchantmentTypeRegistry.getInstance().getRegistryItemStream();
    }
}

