/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.meta;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.PotionEffectType;
import sba.sl.impl.item.meta.PotionEffectRegistry;
import sba.sl.u.ComparableWrapper;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;

public interface PotionEffect
extends ComparableWrapper,
RawValueHolder {
    @NotNull
    public PotionEffectType type();

    public int duration();

    public int amplifier();

    public boolean ambient();

    public boolean particles();

    public boolean icon();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public PotionEffect withDuration(int var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public PotionEffect withAmplifier(int var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public PotionEffect withAmbient(boolean var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public PotionEffect withParticles(boolean var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public PotionEffect withIcon(boolean var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static PotionEffect of(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT) @NotNull Object effect) {
        PotionEffect result = PotionEffect.ofNullable(effect);
        Preconditions.checkNotNullIllegal(result, "Could not find potion effect: " + String.valueOf(effect));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PotionEffect ofNullable(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT) @Nullable Object effect) {
        if (effect instanceof PotionEffect) {
            return (PotionEffect)effect;
        }
        return PotionEffectRegistry.resolve(effect);
    }
}

