/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.meta;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.PotionEffect;
import sba.sl.impl.item.meta.PotionEffectTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface PotionEffectType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Contract(pure=true)
    @NotNull
    default public PotionEffect asEffect() {
        return this.asEffect(0);
    }

    @Contract(pure=true)
    @NotNull
    default public PotionEffect asEffect(int duration) {
        return this.asEffect(duration, 0);
    }

    @Contract(pure=true)
    @NotNull
    default public PotionEffect asEffect(int duration, int amplifier) {
        return this.asEffect(duration, amplifier, true);
    }

    @Contract(pure=true)
    @NotNull
    default public PotionEffect asEffect(int duration, int amplifier, boolean ambient) {
        return this.asEffect(duration, amplifier, ambient, true);
    }

    @Contract(pure=true)
    @NotNull
    default public PotionEffect asEffect(int duration, int amplifier, boolean ambient, boolean particles) {
        return this.asEffect(duration, amplifier, ambient, particles, true);
    }

    @Contract(pure=true)
    @NotNull
    public PotionEffect asEffect(int var1, int var2, boolean var3, boolean var4, boolean var5);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static PotionEffectType of(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT_TYPE) @NotNull Object effectType) {
        PotionEffectType result = PotionEffectType.ofNullable(effectType);
        Preconditions.checkNotNullIllegal(result, "Could not find potion effect type: " + String.valueOf(effectType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PotionEffectType ofNullable(@MinecraftType(value=MinecraftType.Type.POTION_EFFECT_TYPE) @Nullable Object effectType) {
        if (effectType instanceof PotionEffectType) {
            return (PotionEffectType)effectType;
        }
        return (PotionEffectType)PotionEffectTypeRegistry.getInstance().resolveMapping(effectType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull PotionEffectType> all() {
        return PotionEffectTypeRegistry.getInstance().getRegistryItemStream();
    }
}

