/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.spectator.Book;
import sba.sl.spectator.Component;
import sba.sl.u.BasicWrapper;

public class AdventureBook
extends BasicWrapper<sba.k.a.inventory.Book>
implements Book {
    public AdventureBook(@NotNull sba.k.a.inventory.Book wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public Component title() {
        return AdventureBackend.wrapComponent(((sba.k.a.inventory.Book)this.wrappedObject).title());
    }

    @Override
    public @NotNull Book withTitle(@NotNull Component title) {
        return new AdventureBook(((sba.k.a.inventory.Book)this.wrappedObject).title(title.as(sba.k.a.t.Component.class)));
    }

    @Override
    @NotNull
    public Component author() {
        return AdventureBackend.wrapComponent(((sba.k.a.inventory.Book)this.wrappedObject).author());
    }

    @Override
    public @NotNull Book withAuthor(@NotNull Component author) {
        return new AdventureBook(((sba.k.a.inventory.Book)this.wrappedObject).author(author.as(sba.k.a.t.Component.class)));
    }

    @Override
    public @Unmodifiable @NotNull List<Component> pages() {
        return ((sba.k.a.inventory.Book)this.wrappedObject).pages().stream().map(AdventureBackend::wrapComponent).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @NotNull Book withPages(@NotNull List<Component> pages) {
        return new AdventureBook(((sba.k.a.inventory.Book)this.wrappedObject).pages(pages.stream().map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toUnmodifiableList())));
    }

    @Override
    public @NotNull Book withPages(Component ... pages) {
        return new AdventureBook(((sba.k.a.inventory.Book)this.wrappedObject).pages(Arrays.stream(pages).map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toUnmodifiableList())));
    }

    @Override
    public @NotNull Book.Builder toBuilder() {
        return new AdventureBookBuilder(this.title(), this.author(), this.pages());
    }

    public static class AdventureBookBuilder
    implements Book.Builder {
        private Component title = Component.empty();
        private Component author = Component.empty();
        private List<Component> pages = List.of();

        @Override
        @NotNull
        public Book.Builder pages(Component ... pages) {
            this.pages = Arrays.asList(pages);
            return this;
        }

        @Override
        public @NotNull Book build() {
            return new AdventureBook(sba.k.a.inventory.Book.book(this.title.as(sba.k.a.t.Component.class), this.author.as(sba.k.a.t.Component.class), this.pages.stream().map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toUnmodifiableList())));
        }

        @Generated
        public AdventureBookBuilder() {
        }

        @Generated
        public AdventureBookBuilder(Component title, Component author, List<Component> pages) {
            this.title = title;
            this.author = author;
            this.pages = pages;
        }

        @Override
        @Generated
        public AdventureBookBuilder title(Component title) {
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public AdventureBookBuilder author(Component author) {
            this.author = author;
            return this;
        }

        @Override
        @Generated
        public AdventureBookBuilder pages(List<Component> pages) {
            this.pages = pages;
            return this;
        }
    }
}

