/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.sl.api.types.server.BlockHolder;
import sba.sl.b.Block;
import sba.sl.impl.ItemBlockIdsRemapper;
import sba.sl.impl.utils.registry.Registry;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
@ApiStatus.Internal
public abstract class BlockRegistry
extends Registry<Block> {
    @NotNull
    private final @NotNull Map<@NotNull ResourceLocation, ResourceLocation> aliasMap = new HashMap<ResourceLocation, ResourceLocation>();
    @Nullable
    private static BlockRegistry registry;
    @Nullable
    private static Block cachedAir;

    public BlockRegistry() {
        super(Block.class);
        Preconditions.checkArgument(registry == null, "BlockTypeRegistry is already initialized!");
        registry = this;
    }

    @NotNull
    public static BlockRegistry getInstance() {
        return Preconditions.checkNotNull(registry, "BlockTypeRegistry is not initialized yet!");
    }

    @Override
    @Nullable
    protected Block resolveMapping0(@NotNull Object object) {
        ResourceLocation location;
        if (object instanceof ConfigurationNode) {
            object = ((ConfigurationNode)object).getString("");
        }
        @Nullable String blockState = null;
        if (object instanceof ResourceLocation) {
            location = (ResourceLocation)object;
        } else {
            String str = object.toString().trim();
            int index = str.indexOf(91);
            if (index != -1) {
                location = ResourceLocation.ofNullable(str.substring(0, index));
                blockState = str.substring(index);
            } else {
                location = ResourceLocation.ofNullable(str);
            }
        }
        if (location == null) {
            return null;
        }
        Block result = this.resolveMappingPlatform(location, blockState);
        if (result != null) {
            return result;
        }
        ResourceLocation alias = this.aliasMap.get(location);
        if (alias != null) {
            return this.resolveMappingPlatform(alias, blockState);
        }
        return null;
    }

    @NotNull
    public static Block colorize(@NotNull Block holder, @NotNull String color) {
        Preconditions.checkNotNull(registry, "BlockTypeRegistry is not initialized yet!");
        return ItemBlockIdsRemapper.colorableBlocks.entrySet().stream().filter(c -> ((Predicate)c.getKey()).test(holder)).map(Map.Entry::getValue).findFirst().flatMap(fun -> (Optional)fun.apply(color)).orElse(holder);
    }

    @NotNull
    public static Block getCachedAir() {
        if (cachedAir == null) {
            cachedAir = (Block)Preconditions.checkNotNull(registry, "BlockTypeRegistry is not initialized yet!").resolveMapping("minecraft:air");
            Preconditions.checkNotNull(cachedAir, "Could not find block type: minecraft:air");
        }
        return cachedAir;
    }

    public void mapAlias(@NotNull String location, @NotNull String alias) {
        this.mapAlias(ResourceLocation.of(location), ResourceLocation.of(alias));
    }

    protected void mapAlias(@NotNull ResourceLocation location, @NotNull ResourceLocation alias) {
        Block locT = this.resolveMappingPlatform(location, null);
        Block aliasT = this.resolveMappingPlatform(alias, null);
        if (locT == null && aliasT != null) {
            this.aliasMap.put(location, alias);
        } else if (locT != null && aliasT == null) {
            this.aliasMap.put(alias, location);
        } else {
            ResourceLocation locA = this.aliasMap.get(location);
            ResourceLocation aliasA = this.aliasMap.get(alias);
            if (locA == null && aliasA != null) {
                this.aliasMap.put(location, aliasA);
            } else if (locA != null && aliasA == null) {
                this.aliasMap.put(alias, locA);
            }
        }
    }

    @Nullable
    protected abstract Block resolveMappingPlatform(@NotNull ResourceLocation var1, @Nullable String var2);

    static {
        BlockHolder.Provider.registerProvider(o -> Objects.requireNonNull((Block)BlockRegistry.getInstance().resolveMapping(o), "Could not wrap " + String.valueOf(o) + " to Block"));
    }
}

