/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.attribute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.AttributeType;
import sba.sl.impl.attribute.AttributeTypeRegistry;
import sba.sl.impl.bukkit.attribute.BukkitAttributeType1_8;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributeAccessor;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributesAccessor;
import sba.sl.impl.nms.accessors.world.entity.animal.horse.HorseAccessor;
import sba.sl.impl.nms.accessors.world.entity.monster.ZombieAccessor;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitAttributeTypeRegistry1_8
extends AttributeTypeRegistry {
    @NotNull
    public final @NotNull Map<@NotNull ResourceLocation, Object> locationToAttributes = new HashMap<ResourceLocation, Object>();
    @NotNull
    public final @NotNull Map<@NotNull Object, ResourceLocation> attributesToLocation = new HashMap<Object, ResourceLocation>();

    public BukkitAttributeTypeRegistry1_8() {
        this.put("generic.max_health", AttributesAccessor.CONST_MAX_HEALTH.get());
        this.put("generic.follow_range", AttributesAccessor.CONST_FOLLOW_RANGE.get());
        this.put("generic.knockback_resistance", AttributesAccessor.CONST_KNOCKBACK_RESISTANCE.get());
        this.put("generic.movement_speed", AttributesAccessor.CONST_MOVEMENT_SPEED.get());
        this.put("generic.attack_damage", AttributesAccessor.CONST_ATTACK_DAMAGE.get());
        this.put("horse.jump_strength", HorseAccessor.CONST_ATTRIBUTE_JUMP_STRENGTH.get());
        this.put("zombie.spawn_reinforcements", ZombieAccessor.CONST_SPAWN_REINFORCEMENTS_CHANCE.get());
    }

    private void put(@NotNull String path, @Nullable Object attribute) {
        if (attribute != null && AttributeAccessor.TYPE.get() != null && AttributeAccessor.TYPE.get().isInstance(attribute)) {
            ResourceLocation loc = ResourceLocation.of("minecraft", path);
            this.locationToAttributes.put(loc, attribute);
            this.attributesToLocation.put(attribute, loc);
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull AttributeType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Map.Entry, AttributeType>(() -> this.locationToAttributes.entrySet().stream(), entry -> new BukkitAttributeType1_8(entry.getValue()), Map.Entry::getKey, (entry, s) -> ((ResourceLocation)entry.getKey()).path().contains((CharSequence)s), (entry, s) -> "minecraft".equals(s), List.of());
    }

    @Override
    @Nullable
    protected AttributeType resolveMappingPlatform(@NotNull ResourceLocation location) {
        Object attribute = this.locationToAttributes.get(location);
        if (attribute != null) {
            return new BukkitAttributeType1_8(attribute);
        }
        return null;
    }
}

