/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.b.Block;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.bukkit.block.BukkitBlockRegistry1_8;
import sba.sl.impl.bukkit.compat.v1_12_2.LegacyMaterialDataToFlatteningConverter;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitBlock1_8
extends BasicWrapper<MaterialData>
implements Block {
    private final int tileEntityVariant;

    public BukkitBlock1_8(@NotNull Material material) {
        this(material.getNewData((byte)0));
    }

    public BukkitBlock1_8(@NotNull Material material, byte legacyData) {
        this(material.getNewData(legacyData));
    }

    public BukkitBlock1_8(@NotNull Material material, byte legacyData, int tileEntityVariant) {
        this(material.getNewData(legacyData), tileEntityVariant);
    }

    public BukkitBlock1_8(@NotNull MaterialData wrappedObject) {
        this(wrappedObject, 0);
    }

    public BukkitBlock1_8(@NotNull MaterialData wrappedObject, int tileEntityVariant) {
        super(wrappedObject);
        if (!wrappedObject.getItemType().isBlock()) {
            throw new UnsupportedOperationException("Material must be a block!");
        }
        this.tileEntityVariant = tileEntityVariant;
    }

    @Override
    @NotNull
    public String platformName() {
        return ((MaterialData)this.wrappedObject).getItemType().name();
    }

    public byte legacyData() {
        return ((MaterialData)this.wrappedObject).getData();
    }

    public int tileEntityVariant() {
        return this.tileEntityVariant;
    }

    @NotNull
    public Block withLegacyData(byte legacyData) {
        MaterialData clone = ((MaterialData)this.wrappedObject).clone();
        clone.setData(legacyData);
        return new BukkitBlock1_8(clone);
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull Map<@NotNull String, String> stateData() {
        return LegacyMaterialDataToFlatteningConverter.get((MaterialData)this.wrappedObject);
    }

    @Override
    @NotNull
    public BukkitBlock1_8 withStateData(@NotNull @NotNull Map<@NotNull String, String> stateData) {
        String materialName = ((MaterialData)this.wrappedObject).getItemType().name();
        int baseData = 0;
        switch (materialName) {
            case "BURNING_FURNACE": {
                materialName = "FURNACE";
                break;
            }
            case "DIODE_BLOCK_ON": {
                materialName = "DIODE_BLOCK_OFF";
                break;
            }
            case "REDSTONE_COMPARATOR_ON": {
                materialName = "REDSTONE_COMPARATOR_OFF";
                break;
            }
            case "DAYLIGHT_DETECTOR_INVERTED": {
                materialName = "DAYLIGHT_DETECTOR";
                break;
            }
            case "REDSTONE_TORCH_OFF": {
                materialName = "REDSTONE_TORCH_ON";
                break;
            }
            case "REDSTONE_LAMP_ON": {
                materialName = "REDSTONE_LAMP_OFF";
                break;
            }
            case "DOUBLE_STEP": {
                materialName = "STEP";
                break;
            }
            case "WOOD_DOUBLE_STEP": {
                materialName = "WOOD_STEP";
                break;
            }
            case "DOUBLE_STONE_SLAB2": {
                materialName = "STONE_SLAB2";
                break;
            }
            case "PURPUR_DOUBLE_SLAB": {
                materialName = "PURPUR_SLAB";
            }
        }
        switch (materialName) {
            case "LOG": 
            case "LOG_2": {
                if ((((MaterialData)this.wrappedObject).getData() & 0xC) == 12) {
                    baseData = ((MaterialData)this.wrappedObject).getData();
                    break;
                }
            }
            case "LEAVES": 
            case "LEAVES_2": {
                baseData = (byte)(((MaterialData)this.wrappedObject).getData() & 3);
                break;
            }
            case "SAPLING": 
            case "STEP": 
            case "WOOD_STEP": 
            case "STONE_SLAB2": 
            case "PURPUR_SLAB": 
            case "DOUBLE_PLANT": {
                baseData = (byte)(((MaterialData)this.wrappedObject).getData() & 7);
                break;
            }
            case "SAND": 
            case "LONG_GRASS": 
            case "RED_ROSE": 
            case "WOOL": 
            case "STAINED_CLAY": 
            case "STAINED_GLASS": 
            case "STAINED_GLASS_PANE": 
            case "CARPET": 
            case "CONCRETE": 
            case "CONCRETE_POWDER": 
            case "SMOOTH_BRICK": 
            case "MONSTER_EGGS": 
            case "PRISMARINE": 
            case "SPONGE": 
            case "COBBLE_WALL": 
            case "WOOD": 
            case "DIRT": {
                baseData = ((MaterialData)this.wrappedObject).getData();
                break;
            }
            case "TORCH": 
            case "REDSTONE_TORCH_ON": {
                baseData = (byte)(((MaterialData)this.wrappedObject).getData() == 5 ? 5 : 0);
                break;
            }
            case "SKULL": {
                baseData = (byte)(((MaterialData)this.wrappedObject).getData() == 1 ? 1 : 0);
                break;
            }
            case "QUARTZ_BLOCK": {
                baseData = ((MaterialData)this.wrappedObject).getData() > 1 ? 2 : (int)((MaterialData)this.wrappedObject).getData();
                break;
            }
            case "ANVIL": {
                baseData = (byte)(((MaterialData)this.wrappedObject).getData() & 0xC);
            }
        }
        MaterialData materialData = Material.valueOf((String)materialName).getNewData((byte)baseData);
        if (!stateData.isEmpty()) {
            for (Map.Entry<String, String> e : stateData.entrySet()) {
                materialData = LegacyMaterialDataToFlatteningConverter.set(materialData, e.getKey(), e.getValue());
            }
        }
        return new BukkitBlock1_8(materialData, this.tileEntityVariant);
    }

    @Override
    @NotNull
    public Block with(@NotNull String attribute, @NotNull String value) {
        return new BukkitBlock1_8(LegacyMaterialDataToFlatteningConverter.set((MaterialData)this.wrappedObject, attribute, value), this.tileEntityVariant);
    }

    @Override
    @NotNull
    public Block with(@NotNull String attribute, int value) {
        return new BukkitBlock1_8(LegacyMaterialDataToFlatteningConverter.set((MaterialData)this.wrappedObject, attribute, String.valueOf(value)), this.tileEntityVariant);
    }

    @Override
    @NotNull
    public Block with(@NotNull String attribute, boolean value) {
        return new BukkitBlock1_8(LegacyMaterialDataToFlatteningConverter.set((MaterialData)this.wrappedObject, attribute, String.valueOf(value)), this.tileEntityVariant);
    }

    @Override
    @Nullable
    public String get(@NotNull String attribute) {
        return LegacyMaterialDataToFlatteningConverter.get((MaterialData)this.wrappedObject, attribute);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String attribute) {
        String value = LegacyMaterialDataToFlatteningConverter.get((MaterialData)this.wrappedObject, attribute);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String attribute) {
        String value = LegacyMaterialDataToFlatteningConverter.get((MaterialData)this.wrappedObject, attribute);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public boolean isSolid() {
        return ((MaterialData)this.wrappedObject).getItemType().isSolid();
    }

    @Override
    public boolean isTransparent() {
        return ((MaterialData)this.wrappedObject).getItemType().isTransparent();
    }

    @Override
    public boolean isFlammable() {
        return ((MaterialData)this.wrappedObject).getItemType().isFlammable();
    }

    @Override
    public boolean isBurnable() {
        return ((MaterialData)this.wrappedObject).getItemType().isBurnable();
    }

    @Override
    public boolean isOccluding() {
        return ((MaterialData)this.wrappedObject).getItemType().isOccluding();
    }

    @Override
    public boolean hasGravity() {
        return ((MaterialData)this.wrappedObject).getItemType().hasGravity();
    }

    @Override
    public boolean hasTag(@NotNull Object tag) {
        ResourceLocation key = tag instanceof ResourceLocation ? (ResourceLocation)tag : ResourceLocation.of(tag.toString());
        if (!"minecraft".equals(key.namespace())) {
            return false;
        }
        String value = key.path();
        return BukkitBlockRegistry1_8.hasTagInBackPorts(((MaterialData)this.wrappedObject).getItemType(), value);
    }

    @Override
    public boolean isSameType(@Nullable Object object) {
        MaterialData material;
        if (object instanceof Material) {
            return ((MaterialData)this.wrappedObject).getItemType() == object;
        }
        int otherTileEntityData = 0;
        if (object instanceof MaterialData) {
            material = (MaterialData)object;
        } else if (object instanceof BukkitBlock1_8) {
            material = (MaterialData)((BukkitBlock1_8)object).wrappedObject;
            otherTileEntityData = ((BukkitBlock1_8)object).tileEntityVariant;
        } else {
            Block block = Block.ofNullable(object);
            if (block == null) {
                return false;
            }
            otherTileEntityData = ((BukkitBlock1_8)block).tileEntityVariant;
            material = (MaterialData)((BukkitBlock1_8)block).wrappedObject;
        }
        String materialName = material.getItemType().name();
        String ourMaterialName = ((MaterialData)this.wrappedObject).getItemType().name();
        switch (materialName) {
            case "FURNACE": 
            case "BURNING_FURNACE": {
                if (!"FURNACE".equals(ourMaterialName) && !"BURNING_FURNACE".equals(ourMaterialName)) break;
                return true;
            }
            case "DIODE_BLOCK_OFF": 
            case "DIODE_BLOCK_ON": {
                if (!"DIODE_BLOCK_OFF".equals(ourMaterialName) && !"DIODE_BLOCK_ON".equals(ourMaterialName)) break;
                return true;
            }
            case "REDSTONE_COMPARATOR_ON": 
            case "REDSTONE_COMPARATOR_OFF": {
                if (!"REDSTONE_COMPARATOR_ON".equals(ourMaterialName) && !"REDSTONE_COMPARATOR_OFF".equals(ourMaterialName)) break;
                return true;
            }
            case "DAYLIGHT_DETECTOR": 
            case "DAYLIGHT_DETECTOR_INVERTED": {
                if (!"DAYLIGHT_DETECTOR".equals(ourMaterialName) && !"DAYLIGHT_DETECTOR_INVERTED".equals(ourMaterialName)) break;
                return true;
            }
            case "REDSTONE_TORCH_OFF": 
            case "REDSTONE_TORCH_ON": {
                if (!"REDSTONE_TORCH_OFF".equals(ourMaterialName) && !"REDSTONE_TORCH_ON".equals(ourMaterialName)) break;
                return true;
            }
            case "REDSTONE_LAMP_ON": 
            case "REDSTONE_LAMP_OFF": {
                if (!"REDSTONE_LAMP_ON".equals(ourMaterialName) && !"REDSTONE_LAMP_OFF".equals(ourMaterialName)) break;
                return true;
            }
            case "STEP": 
            case "DOUBLE_STEP": {
                if ("STEP".equals(ourMaterialName) || "DOUBLE_STEP".equals(ourMaterialName)) break;
                return false;
            }
            case "WOOD_STEP": 
            case "WOOD_DOUBLE_STEP": {
                if ("WOOD_STEP".equals(ourMaterialName) || "WOOD_DOUBLE_STEP".equals(ourMaterialName)) break;
                return false;
            }
            case "STONE_SLAB2": 
            case "DOUBLE_STONE_SLAB2": {
                if ("STONE_SLAB2".equals(ourMaterialName) || "DOUBLE_STONE_SLAB2".equals(ourMaterialName)) break;
                return false;
            }
            case "PURPUR_SLAB": 
            case "PURPUR_DOUBLE_SLAB": {
                if ("PURPUR_SLAB".equals(ourMaterialName) || "PURPUR_DOUBLE_SLAB".equals(ourMaterialName)) break;
                return false;
            }
            default: {
                if (((MaterialData)this.wrappedObject).getItemType() == material.getItemType()) break;
                return false;
            }
        }
        switch (materialName) {
            case "LOG": 
            case "LOG_2": {
                if ((material.getData() & 0xC) == 12) {
                    return material.getData() == ((MaterialData)this.wrappedObject).getData();
                }
            }
            case "LEAVES": 
            case "LEAVES_2": {
                return (material.getData() & 3) == (((MaterialData)this.wrappedObject).getData() & 3);
            }
            case "SAPLING": 
            case "STEP": 
            case "WOOD_STEP": 
            case "STONE_SLAB2": 
            case "PURPUR_SLAB": 
            case "DOUBLE_STEP": 
            case "WOOD_DOUBLE_STEP": 
            case "DOUBLE_STONE_SLAB2": 
            case "PURPUR_DOUBLE_SLAB": 
            case "DOUBLE_PLANT": {
                return (material.getData() & 7) == (((MaterialData)this.wrappedObject).getData() & 7);
            }
            case "SAND": 
            case "LONG_GRASS": 
            case "RED_ROSE": 
            case "WOOL": 
            case "STAINED_CLAY": 
            case "STAINED_GLASS": 
            case "STAINED_GLASS_PANE": 
            case "CARPET": 
            case "CONCRETE": 
            case "CONCRETE_POWDER": 
            case "SMOOTH_BRICK": 
            case "MONSTER_EGGS": 
            case "PRISMARINE": 
            case "SPONGE": 
            case "COBBLE_WALL": 
            case "WOOD": 
            case "DIRT": {
                return material.getData() == ((MaterialData)this.wrappedObject).getData();
            }
            case "TORCH": 
            case "REDSTONE_TORCH_ON": 
            case "REDSTONE_TORCH_OFF": {
                return material.getData() == 5 && ((MaterialData)this.wrappedObject).getData() == 5 || material.getData() != 5 && ((MaterialData)this.wrappedObject).getData() != 5;
            }
            case "SKULL": {
                return this.tileEntityVariant == otherTileEntityData && (material.getData() == 1 && ((MaterialData)this.wrappedObject).getData() == 1 || material.getData() != 1 && ((MaterialData)this.wrappedObject).getData() != 1);
            }
            case "QUARTZ_BLOCK": {
                return material.getData() > 1 && ((MaterialData)this.wrappedObject).getData() > 1 || material.getData() == ((MaterialData)this.wrappedObject).getData();
            }
            case "ANVIL": {
                return (material.getData() & 0xC) == (((MaterialData)this.wrappedObject).getData() & 0xC);
            }
            case "FLOWER_POT": 
            case "BED_BLOCK": {
                return this.tileEntityVariant == otherTileEntityData;
            }
        }
        return true;
    }

    @Override
    public boolean isSameType(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::isSameType);
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof MaterialData || object instanceof BukkitBlock1_8) {
            return this.equals(object);
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.startsWith("#")) {
                return this.hasTag(str.substring(1));
            }
            if (str.endsWith("[*]")) {
                return this.isSameType((Object)str.substring(0, str.length() - 3));
            }
        }
        return this.equals(Block.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public String completeState() {
        Map<String, String> data = this.stateData();
        if (!data.isEmpty()) {
            return this.location().asString() + "[" + data.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")) + "]";
        }
        return this.location().asString();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == Material.class) {
            return (T)((MaterialData)this.wrappedObject).getItemType();
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        BlockRegistry registry = BlockRegistry.getInstance();
        if (registry instanceof BukkitBlockRegistry1_8) {
            Block newType = this.withStateData(Map.of());
            ResourceLocation location = ((BukkitBlockRegistry1_8)registry).getResourceLocations().get(newType);
            if (location != null) {
                return location;
            }
        }
        return ResourceLocation.of("minecraft:legacy/" + this.platformName() + "/" + ((MaterialData)this.wrappedObject).getData());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tileEntityVariant);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) && (!(obj instanceof BukkitBlock1_8) || ((BukkitBlock1_8)obj).tileEntityVariant == this.tileEntityVariant);
    }
}

