/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.Container;
import sba.sl.cn.ContainerFactory;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.e.type.EntityType;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.compat.v1_12_2.AsyncChunk1_9;
import sba.sl.impl.bukkit.entity.type.BukkitEntityType1_11;
import sba.sl.impl.bukkit.entity.type.BukkitEntityType1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.server.VVV.EnumZombieTypeAccessor;
import sba.sl.impl.nms.accessors.world.entity.EntityAccessor;
import sba.sl.impl.nms.accessors.world.entity.monster.ZombieAccessor;
import sba.sl.impl.world.Locations;
import sba.sl.spectator.Component;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;
import sba.sl.u.math.Vector3D;
import sba.sl.u.reflect.Reflect;
import sba.sl.w.Location;

public class BukkitEntity
extends BasicWrapper<org.bukkit.entity.Entity>
implements Entity {
    public BukkitEntity(@NotNull org.bukkit.entity.Entity wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public EntityType getEntityType() {
        if (!BukkitFeature.NORMAL_ENTITY_RESOURCE_LOCATIONS.isSupported()) {
            if (this.wrappedObject instanceof Horse) {
                Horse.Variant variant = ((Horse)this.wrappedObject).getVariant();
                switch (variant) {
                    case DONKEY: {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 1);
                    }
                    case MULE: {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 2);
                    }
                    case SKELETON_HORSE: {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 3);
                    }
                    case UNDEAD_HORSE: {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 4);
                    }
                }
            } else if (this.wrappedObject instanceof Zombie) {
                Object villager;
                if (BukkitFeature.HUSK.isSupported() && (villager = Reflect.fastInvoke(ZombieAccessor.METHOD_GET_VILLAGER_TYPE.get(), ClassStorage.getHandle(this.wrappedObject))) != null && villager == EnumZombieTypeAccessor.CONST_HUSK.get()) {
                    return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 2);
                }
                if (((Zombie)this.wrappedObject).isVillager()) {
                    return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 1);
                }
            } else if (this.wrappedObject instanceof Skeleton) {
                Skeleton.SkeletonType variant = ((Skeleton)this.wrappedObject).getSkeletonType();
                switch (variant.name()) {
                    case "WITHER": {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 1);
                    }
                    case "STRAY": {
                        return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 2);
                    }
                }
            } else {
                if (this.wrappedObject instanceof Guardian && ((Guardian)this.wrappedObject).isElder()) {
                    return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType(), 1);
                }
                return new BukkitEntityType1_8(((org.bukkit.entity.Entity)this.wrappedObject).getType());
            }
        }
        return new BukkitEntityType1_11(((org.bukkit.entity.Entity)this.wrappedObject).getType());
    }

    @Override
    @NotNull
    public Location getLocation() {
        return Locations.wrapLocation(((org.bukkit.entity.Entity)this.wrappedObject).getLocation());
    }

    @Override
    @NotNull
    public Vector3D getVelocity() {
        Vector platformVector = ((org.bukkit.entity.Entity)this.wrappedObject).getVelocity();
        return new Vector3D(platformVector.getX(), platformVector.getY(), platformVector.getZ());
    }

    @Override
    public void setVelocity(@NotNull Vector3D velocity) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setVelocity(new Vector(velocity.getX(), velocity.getY(), velocity.getZ()));
    }

    @Override
    public double getHeight() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getHeight();
    }

    @Override
    public double getWidth() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getWidth();
    }

    @Override
    public boolean isOnGround() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isOnGround();
    }

    @Override
    public boolean isInWater() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isInWater();
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Boolean> teleport(@NotNull Location locationHolder) {
        if (BukkitFeature.TELEPORT_ASYNC.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).teleportAsync(locationHolder.as(org.bukkit.Location.class));
        }
        if (BukkitFeature.CHUNK_ASYNC_1_9.isSupported()) {
            org.bukkit.Location loc = locationHolder.as(org.bukkit.Location.class);
            return AsyncChunk1_9.getChunkAtAsync(loc).thenApply(chunk -> ((org.bukkit.entity.Entity)this.wrappedObject).teleport(loc));
        }
        return CompletableFuture.completedFuture(((org.bukkit.entity.Entity)this.wrappedObject).teleport(locationHolder.as(org.bukkit.Location.class)));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> teleport(@NotNull Location location, @NotNull Runnable callback, boolean forceCallback) {
        return ((CompletableFuture)this.teleport(location).thenAccept(result -> {
            if (result.booleanValue() || forceCallback) {
                callback.run();
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    @Override
    public boolean teleportSync(@NotNull Location location) {
        return ((org.bukkit.entity.Entity)this.wrappedObject).teleport(location.as(org.bukkit.Location.class));
    }

    @Override
    public int getEntityId() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getEntityId();
    }

    @Override
    public int getFireTicks() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getFireTicks();
    }

    @Override
    public int getMaxFireTicks() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getMaxFireTicks();
    }

    @Override
    public void setFireTicks(int fireTicks) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setFireTicks(fireTicks);
    }

    @Override
    public void remove() {
        ((org.bukkit.entity.Entity)this.wrappedObject).remove();
    }

    @Override
    public boolean isDead() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isDead();
    }

    @Override
    public boolean isPersistent() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isPersistent();
    }

    @Override
    public void setPersistent(boolean persistent) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setPersistent(persistent);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Entity> getPassengers() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getPassengers().stream().map(Entities::wrapEntity).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean addPassenger(@NotNull Entity passenger) {
        org.bukkit.entity.Entity bukkitPassenger = passenger.as(org.bukkit.entity.Entity.class);
        Preconditions.checkArgument(bukkitPassenger != this.wrappedObject, "Entity cannot ride itself.");
        if (BukkitFeature.ENTITY_ADD_PASSENGER.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).addPassenger(bukkitPassenger);
        }
        if (EntityAccessor.METHOD_START_RIDING.get() != null) {
            return (Boolean)Reflect.fastInvoke(ClassStorage.getHandle(bukkitPassenger), EntityAccessor.METHOD_START_RIDING.get(), ClassStorage.getHandle(this.wrappedObject), true);
        }
        return ((org.bukkit.entity.Entity)this.wrappedObject).setPassenger(bukkitPassenger);
    }

    @Override
    public boolean removePassenger(@NotNull Entity passenger) {
        if (BukkitFeature.ENTITY_REMOVE_PASSENGER.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).removePassenger(passenger.as(org.bukkit.entity.Entity.class));
        }
        if (EntityAccessor.METHOD_STOP_RIDING.get() != null) {
            Reflect.fastInvoke(ClassStorage.getHandle(passenger.as(org.bukkit.entity.Entity.class)), EntityAccessor.METHOD_STOP_RIDING.get());
            return true;
        }
        return ((org.bukkit.entity.Entity)this.wrappedObject).eject();
    }

    @Override
    public boolean hasPassengers() {
        return !((org.bukkit.entity.Entity)this.wrappedObject).isEmpty();
    }

    @Override
    public boolean ejectPassengers() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).eject();
    }

    @Override
    public float getFallDistance() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getFallDistance();
    }

    @Override
    public void setFallDistance(float distance) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setFallDistance(distance);
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getUniqueId();
    }

    @Override
    public int getTicksLived() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getTicksLived();
    }

    @Override
    public void setTicksLived(int value) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setTicksLived(value);
    }

    @Override
    public boolean isInsideVehicle() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isInsideVehicle();
    }

    @Override
    public boolean leaveVehicle() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).leaveVehicle();
    }

    @Override
    @Nullable
    public Entity getVehicle() {
        return Entities.wrapEntity(((org.bukkit.entity.Entity)this.wrappedObject).getVehicle());
    }

    @Override
    public void setCustomName(@Nullable String name) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setCustomName(name);
    }

    @Override
    public void setCustomName(@Nullable Component name) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).customName(name == null ? null : name.as(sba.k.a.t.Component.class));
        } else {
            ((org.bukkit.entity.Entity)this.wrappedObject).setCustomName(name == null ? null : name.toLegacy());
        }
    }

    @Override
    @Nullable
    public Component getCustomName() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(((org.bukkit.entity.Entity)this.wrappedObject).customName());
        }
        return Component.fromLegacy(((org.bukkit.entity.Entity)this.wrappedObject).getCustomName());
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        ((org.bukkit.entity.Entity)this.wrappedObject).setCustomNameVisible(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isCustomNameVisible();
    }

    @Override
    public void setGlowing(boolean flag) {
        if (BukkitFeature.ENTITY_IS_GLOWING.isSupported()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).setGlowing(flag);
        }
    }

    @Override
    public boolean isGlowing() {
        if (BukkitFeature.ENTITY_IS_GLOWING.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).isGlowing();
        }
        return false;
    }

    @Override
    public void setInvulnerable(boolean flag) {
        if (BukkitFeature.ENTITY_IS_INVULNERABLE.isSupported()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).setInvulnerable(flag);
        }
    }

    @Override
    public boolean isInvulnerable() {
        if (BukkitFeature.ENTITY_IS_INVULNERABLE.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).isInvulnerable();
        }
        return false;
    }

    @Override
    public boolean isSilent() {
        if (BukkitFeature.ENTITY_IS_SILENT.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).isSilent();
        }
        return false;
    }

    @Override
    public void setSilent(boolean flag) {
        if (BukkitFeature.ENTITY_IS_SILENT.isSupported()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).setSilent(flag);
        }
    }

    @Override
    public boolean hasGravity() {
        if (BukkitFeature.ENTITY_HAS_GRAVITY.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).hasGravity();
        }
        return false;
    }

    @Override
    public void setGravity(boolean gravity) {
        if (BukkitFeature.ENTITY_HAS_GRAVITY.isSupported()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).setGravity(gravity);
        }
    }

    @Override
    public int getPortalCooldown() {
        if (BukkitFeature.ENTITY_PORTAL_COOLDOWN.isSupported()) {
            return ((org.bukkit.entity.Entity)this.wrappedObject).getPortalCooldown();
        }
        return 0;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        if (BukkitFeature.ENTITY_PORTAL_COOLDOWN.isSupported()) {
            ((org.bukkit.entity.Entity)this.wrappedObject).setPortalCooldown(cooldown);
        }
    }

    @Override
    public boolean holdsInventory() {
        return this.wrappedObject instanceof InventoryHolder;
    }

    @Override
    @Nullable
    public Container getInventory() {
        if (!(this.wrappedObject instanceof InventoryHolder)) {
            return null;
        }
        return ContainerFactory.wrapContainer(((InventoryHolder)this.wrappedObject).getInventory());
    }
}

