/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.AttributeType;
import sba.sl.b.Block;
import sba.sl.b.BlockPlacement;
import sba.sl.cn.Container;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.e.HumanEntity;
import sba.sl.e.projectile.ProjectileEntity;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.i.meta.PotionEffect;
import sba.sl.impl.attribute.Attributes;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.attribute.BukkitAttributeType1_8;
import sba.sl.impl.bukkit.attribute.BukkitAttributeType1_9;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitEntity;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.world.InteractionHandAccessor;
import sba.sl.impl.nms.accessors.world.entity.EntityAccessor;
import sba.sl.impl.nms.accessors.world.entity.LivingEntityAccessor;
import sba.sl.impl.nms.accessors.world.entity.MobAccessor;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributeInstanceAccessor;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributeMapAccessor;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributeSupplierAccessor;
import sba.sl.impl.nms.accessors.world.entity.player.PlayerAccessor;
import sba.sl.impl.world.Locations;
import sba.sl.u.Preconditions;
import sba.sl.u.math.Vector3D;
import sba.sl.u.reflect.ClassMethod;
import sba.sl.u.reflect.Reflect;

public class BukkitLivingEntity
extends BukkitEntity
implements sba.sl.e.LivingEntity {
    public BukkitLivingEntity(@NotNull LivingEntity wrappedObject) {
        super((org.bukkit.entity.Entity)wrappedObject);
    }

    @Override
    @Nullable
    public sba.sl.a.Attribute getAttribute(@NotNull AttributeType attributeType) {
        if (BukkitFeature.ATTRIBUTES_API.isSupported()) {
            return Attributes.wrapAttribute(((LivingEntity)this.wrappedObject).getAttribute(attributeType.as(Attribute.class)));
        }
        if (attributeType instanceof BukkitAttributeType1_8) {
            return Attributes.wrapAttribute(Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_GET_ATTRIBUTE.get(), attributeType.raw()));
        }
        return null;
    }

    @Override
    @NotNull
    public sba.sl.a.Attribute getOrCreateAttribute(@NotNull AttributeType attributeType, double defaultValue) {
        sba.sl.a.Attribute finalAttribute;
        sba.sl.a.Attribute attribute = this.getAttribute(attributeType);
        if (attribute != null) {
            return attribute;
        }
        Object handler = ClassStorage.getHandle(this.wrappedObject);
        Object attrMap = Reflect.fastInvoke(handler, LivingEntityAccessor.METHOD_GET_ATTRIBUTES.get());
        Object attr = null;
        if (BukkitFeature.ATTRIBUTES_API.isSupported()) {
            ClassMethod toMinecraftNewMethod = Reflect.getMethod(ClassStorage.CB.CraftAttribute, "bukkitToMinecraftHolder", Attribute.class);
            if (toMinecraftNewMethod.getMethod() == null && (toMinecraftNewMethod = Reflect.getMethod(ClassStorage.CB.CraftAttribute, "bukkitToMinecraft", Attribute.class)).getMethod() == null) {
                toMinecraftNewMethod = Reflect.getMethod(ClassStorage.CB.CraftAttributeMap, "toMinecraft", Attribute.class);
            }
            if (toMinecraftNewMethod.getMethod() != null && toMinecraftNewMethod.getMethod().getReturnType() != String.class) {
                attr = toMinecraftNewMethod.invokeStatic(attributeType.as(Attribute.class));
            } else if (attributeType instanceof BukkitAttributeType1_9) {
                attr = ((BukkitAttributeType1_9)attributeType).getVanillaAttribute();
            }
        } else if (attributeType instanceof BukkitAttributeType1_8) {
            attr = attributeType.raw();
        }
        if (attr == null) {
            throw new UnsupportedOperationException("Cannot create a new attribute instance!");
        }
        Object attr0 = Reflect.fastInvoke(attrMap, AttributeMapAccessor.METHOD_REGISTER_ATTRIBUTE.get(), attr);
        if (attr0 == null || !AttributeInstanceAccessor.TYPE.get().isInstance(attr0)) {
            Object provider = Reflect.getField(attrMap, AttributeMapAccessor.FIELD_SUPPLIER.get());
            HashMap all = Maps.newHashMap((Map)((Map)Reflect.getField(provider, AttributeSupplierAccessor.FIELD_INSTANCES.get())));
            attr0 = AttributeInstanceAccessor.CONSTRUCTOR_0.get() != null ? Reflect.construct(AttributeInstanceAccessor.CONSTRUCTOR_0.get(), attr, o -> {}) : Reflect.construct(AttributeInstanceAccessor.CONSTRUCTOR_1.get(), attr, o -> {});
            all.put(attr, attr0);
            Reflect.setField(provider, AttributeSupplierAccessor.FIELD_INSTANCES.get(), (Object)ImmutableMap.copyOf((Map)all));
        }
        if ((finalAttribute = this.getAttribute(attributeType)) == null) {
            throw new UnsupportedOperationException("Could not create a new instance of type " + String.valueOf(attributeType.location()) + " for entity " + String.valueOf(this.wrappedObject));
        }
        return finalAttribute;
    }

    @Override
    public double getEyeHeight() {
        return ((LivingEntity)this.wrappedObject).getEyeHeight();
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        return ((LivingEntity)this.wrappedObject).getEyeHeight(ignorePose);
    }

    @Override
    @NotNull
    public sba.sl.w.Location getEyeLocation() {
        return Locations.wrapLocation(((LivingEntity)this.wrappedObject).getEyeLocation());
    }

    @Override
    @NotNull
    public BlockPlacement getTargetBlock(@Nullable Collection<@NotNull Block> transparent, int maxDistance) {
        return new BukkitBlockPlacement(((LivingEntity)this.wrappedObject).getTargetBlock(transparent == null ? null : transparent.stream().map(material -> material.as(Material.class)).collect(Collectors.toSet()), maxDistance));
    }

    @Override
    @Nullable
    public BlockPlacement getTargetBlock(int maxDistance) {
        org.bukkit.block.Block targetBlock = ((LivingEntity)this.wrappedObject).getTargetBlockExact(maxDistance);
        return targetBlock != null ? new BukkitBlockPlacement(targetBlock) : null;
    }

    @Override
    public int getRemainingAir() {
        return ((LivingEntity)this.wrappedObject).getRemainingAir();
    }

    @Override
    public void setRemainingAir(int ticks) {
        ((LivingEntity)this.wrappedObject).setRemainingAir(ticks);
    }

    @Override
    public int getMaximumAir() {
        return ((LivingEntity)this.wrappedObject).getMaximumAir();
    }

    @Override
    public void setMaximumAir(int ticks) {
        ((LivingEntity)this.wrappedObject).setMaximumAir(ticks);
    }

    @Override
    public int getArrowCooldown() {
        if (BukkitFeature.ARROW_COOLDOWN.isSupported()) {
            return ((LivingEntity)this.wrappedObject).getArrowCooldown();
        }
        return (Integer)Reflect.getField(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.FIELD_REMOVE_ARROW_TIME.get());
    }

    @Override
    public void setArrowCooldown(int ticks) {
        if (BukkitFeature.ARROW_COOLDOWN.isSupported()) {
            ((LivingEntity)this.wrappedObject).setArrowCooldown(ticks);
        } else {
            Reflect.setField(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.FIELD_REMOVE_ARROW_TIME.get(), (Object)ticks);
        }
    }

    @Override
    public int getArrowsInBody() {
        if (BukkitFeature.ARROWS_IN_BODY.isSupported()) {
            return ((LivingEntity)this.wrappedObject).getArrowsInBody();
        }
        return (Integer)Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_GET_ARROW_COUNT.get());
    }

    @Override
    public void setArrowsInBody(int count) {
        Preconditions.checkArgument(count >= 0, "Arrow count cannot be negative.");
        if (BukkitFeature.ARROWS_IN_BODY.isSupported()) {
            ((LivingEntity)this.wrappedObject).setArrowsInBody(count);
        } else {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_SET_ARROW_COUNT.get(), count);
        }
    }

    @Override
    public int getMaximumNoDamageTicks() {
        return ((LivingEntity)this.wrappedObject).getMaximumNoDamageTicks();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        ((LivingEntity)this.wrappedObject).setMaximumNoDamageTicks(ticks);
    }

    @Override
    public double getLastDamage() {
        return ((LivingEntity)this.wrappedObject).getLastDamage();
    }

    @Override
    public void setLastDamage(double damage) {
        ((LivingEntity)this.wrappedObject).setLastDamage(damage);
    }

    @Override
    public int getNoDamageTicks() {
        return ((LivingEntity)this.wrappedObject).getNoDamageTicks();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        ((LivingEntity)this.wrappedObject).setNoDamageTicks(ticks);
    }

    @Override
    @Nullable
    public HumanEntity getHumanKiller() {
        return Entities.wrapEntityHuman(((LivingEntity)this.wrappedObject).getKiller());
    }

    @Override
    public boolean addPotionEffect(@NotNull PotionEffect effect) {
        return ((LivingEntity)this.wrappedObject).addPotionEffect(effect.as(org.bukkit.potion.PotionEffect.class));
    }

    @Override
    public boolean addPotionEffects(@NotNull @NotNull Collection<@NotNull PotionEffect> effects) {
        return ((LivingEntity)this.wrappedObject).addPotionEffects((Collection)effects.stream().map(effect -> effect.as(org.bukkit.potion.PotionEffect.class)).collect(Collectors.toSet()));
    }

    @Override
    public boolean hasPotionEffect(@NotNull PotionEffect type) {
        return ((LivingEntity)this.wrappedObject).hasPotionEffect(type.as(org.bukkit.potion.PotionEffect.class).getType());
    }

    @Override
    public void removePotionEffect(@NotNull PotionEffect type) {
        ((LivingEntity)this.wrappedObject).removePotionEffect(type.as(org.bukkit.potion.PotionEffect.class).getType());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull PotionEffect> getActivePotionEffects() {
        return ((LivingEntity)this.wrappedObject).getActivePotionEffects().stream().map(PotionEffect::of).collect(Collectors.toList());
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return ((LivingEntity)this.wrappedObject).getRemoveWhenFarAway();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        ((LivingEntity)this.wrappedObject).setRemoveWhenFarAway(remove);
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        ((LivingEntity)this.wrappedObject).setCanPickupItems(pickup);
    }

    @Override
    public boolean getCanPickupItems() {
        return ((LivingEntity)this.wrappedObject).getCanPickupItems();
    }

    @Override
    public boolean isLeashed() {
        return ((LivingEntity)this.wrappedObject).isLeashed();
    }

    @Override
    @Nullable
    public Entity getLeashHolder() {
        if (this.isLeashed()) {
            return Entities.wrapEntity(((LivingEntity)this.wrappedObject).getLeashHolder());
        }
        return null;
    }

    @Override
    public boolean setLeashHolder(@Nullable Entity holder) {
        return ((LivingEntity)this.wrappedObject).setLeashHolder(holder != null ? holder.as(org.bukkit.entity.Entity.class) : null);
    }

    @Override
    public boolean removeLeashHolder() {
        return ((LivingEntity)this.wrappedObject).setLeashHolder(null);
    }

    @Override
    public boolean isGliding() {
        if (BukkitFeature.GLIDING.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isGliding();
        }
        return false;
    }

    @Override
    public void setGliding(boolean gliding) {
        if (BukkitFeature.GLIDING.isSupported()) {
            ((LivingEntity)this.wrappedObject).setGliding(gliding);
        }
    }

    @Override
    public boolean isSwimming() {
        if (BukkitFeature.SWIMMING.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isSwimming();
        }
        return false;
    }

    @Override
    public void setSwimming(boolean swimming) {
        if (BukkitFeature.SWIMMING.isSupported()) {
            ((LivingEntity)this.wrappedObject).setSwimming(swimming);
        }
    }

    @Override
    public boolean isRiptiding() {
        if (BukkitFeature.RIPTIDING.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isRiptiding();
        }
        return false;
    }

    @Override
    public boolean isSleeping() {
        if (BukkitFeature.SLEEPING.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isSleeping();
        }
        if (this.wrappedObject instanceof org.bukkit.entity.HumanEntity) {
            return ((org.bukkit.entity.HumanEntity)this.wrappedObject).isSleeping();
        }
        return false;
    }

    @Override
    public void setAI(boolean ai) {
        if (BukkitFeature.SET_AI.isSupported()) {
            ((LivingEntity)this.wrappedObject).setAI(ai);
        } else if (MobAccessor.TYPE.get().isInstance(ClassStorage.getHandle(this.wrappedObject))) {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), MobAccessor.METHOD_SET_NO_AI.get(), !ai);
        }
    }

    @Override
    public boolean hasAI() {
        if (BukkitFeature.SET_AI.isSupported()) {
            return ((LivingEntity)this.wrappedObject).hasAI();
        }
        if (MobAccessor.TYPE.get().isInstance(ClassStorage.getHandle(this.wrappedObject))) {
            return (Boolean)Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), MobAccessor.METHOD_IS_NO_AI.get()) == false;
        }
        return false;
    }

    @Override
    public void attack(@NotNull Entity target) {
        if (BukkitFeature.ATTACK.isSupported()) {
            ((LivingEntity)this.wrappedObject).attack(target.as(org.bukkit.entity.Entity.class));
        } else if (PlayerAccessor.TYPE.get().isInstance(ClassStorage.getHandle(this.wrappedObject))) {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), PlayerAccessor.METHOD_ATTACK.get(), ClassStorage.getHandle(target.as(org.bukkit.entity.Entity.class)));
        } else {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_DO_HURT_TARGET.get(), ClassStorage.getHandle(target.as(org.bukkit.entity.Entity.class)));
        }
    }

    @Override
    public void swingMainHand() {
        if (BukkitFeature.SWING_HAND.isSupported()) {
            ((LivingEntity)this.wrappedObject).swingMainHand();
        } else if (LivingEntityAccessor.METHOD_SWING.get() != null) {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_SWING.get(), InteractionHandAccessor.CONST_MAIN_HAND.get());
        }
    }

    @Override
    public void swingOffHand() {
        if (BukkitFeature.SWING_HAND.isSupported()) {
            ((LivingEntity)this.wrappedObject).swingOffHand();
        } else if (LivingEntityAccessor.METHOD_SWING.get() != null) {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_SWING.get(), InteractionHandAccessor.CONST_OFF_HAND.get());
        }
    }

    @Override
    public void setCollidable(boolean collidable) {
        if (BukkitFeature.COLLIDABLE.isSupported()) {
            ((LivingEntity)this.wrappedObject).setCollidable(collidable);
        }
    }

    @Override
    public boolean isCollidable() {
        if (BukkitFeature.COLLIDABLE.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isCollidable();
        }
        return !(this.wrappedObject instanceof org.bukkit.entity.HumanEntity);
    }

    @Override
    public void setInvisible(boolean invisible) {
        if (BukkitFeature.INVISIBLE.isSupported()) {
            ((LivingEntity)this.wrappedObject).setInvisible(invisible);
        } else if (this.wrappedObject instanceof ArmorStand) {
            ((ArmorStand)this.wrappedObject).setVisible(!invisible);
        } else {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), EntityAccessor.METHOD_SET_INVISIBLE.get(), invisible);
        }
    }

    @Override
    public boolean isInvisible() {
        if (BukkitFeature.INVISIBLE.isSupported()) {
            return ((LivingEntity)this.wrappedObject).isInvisible();
        }
        if (this.wrappedObject instanceof ArmorStand) {
            return !((ArmorStand)this.wrappedObject).isVisible();
        }
        return (Boolean)Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), EntityAccessor.METHOD_IS_INVISIBLE.get());
    }

    @Override
    public void damage(double amount) {
        ((LivingEntity)this.wrappedObject).damage(amount);
    }

    @Override
    public void damage(double amount, @Nullable Entity damageSource) {
        ((LivingEntity)this.wrappedObject).damage(amount, damageSource != null ? damageSource.as(org.bukkit.entity.Entity.class) : null);
    }

    @Override
    public double getAbsorptionAmount() {
        if (BukkitFeature.ABSORPTION_AMOUNT.isSupported()) {
            return ((LivingEntity)this.wrappedObject).getAbsorptionAmount();
        }
        return ((Float)Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_GET_ABSORPTION_AMOUNT.get())).floatValue();
    }

    @Override
    public double getHealth() {
        return ((LivingEntity)this.wrappedObject).getHealth();
    }

    @Override
    public void setAbsorptionAmount(double amount) {
        if (BukkitFeature.ABSORPTION_AMOUNT.isSupported()) {
            ((LivingEntity)this.wrappedObject).setAbsorptionAmount(amount);
        } else {
            Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), LivingEntityAccessor.METHOD_SET_ABSORPTION_AMOUNT.get(), Float.valueOf((float)amount));
        }
    }

    @Override
    public void setHealth(double health) {
        ((LivingEntity)this.wrappedObject).setHealth(health);
    }

    @Override
    @Nullable
    public ItemStack getHelmet() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getHelmet() == null) {
            return null;
        }
        return new BukkitItem(eq.getHelmet());
    }

    @Override
    @Nullable
    public ItemStack getChestplate() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getChestplate() == null) {
            return null;
        }
        return new BukkitItem(eq.getChestplate());
    }

    @Override
    @Nullable
    public ItemStack getLeggings() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getLeggings() == null) {
            return null;
        }
        return new BukkitItem(eq.getLeggings());
    }

    @Override
    @Nullable
    public ItemStack getBoots() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getBoots() == null) {
            return null;
        }
        return new BukkitItem(eq.getBoots());
    }

    @Override
    public void setHelmet(@Nullable ItemStack helmet) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (helmet == null) {
            eq.setHelmet(null);
        } else {
            eq.setHelmet(helmet.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    public void setChestplate(@Nullable ItemStack chestplate) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (chestplate == null) {
            eq.setChestplate(null);
        } else {
            eq.setChestplate(chestplate.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    public void setLeggings(@Nullable ItemStack leggings) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (leggings == null) {
            eq.setLeggings(null);
        } else {
            eq.setLeggings(leggings.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    public void setBoots(@Nullable ItemStack boots) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (boots == null) {
            eq.setBoots(null);
        } else {
            eq.setBoots(boots.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    @Nullable
    public ItemStack getItemInMainHand() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return null;
        }
        if (BukkitFeature.OFF_HAND.isSupported()) {
            return new BukkitItem(eq.getItemInMainHand());
        }
        return new BukkitItem(eq.getItemInHand());
    }

    @Override
    public void setItemInMainHand(@Nullable ItemStack item) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (BukkitFeature.OFF_HAND.isSupported()) {
            if (item == null) {
                eq.setItemInMainHand(null);
            } else {
                eq.setItemInMainHand(item.as(org.bukkit.inventory.ItemStack.class));
            }
        } else if (item == null) {
            eq.setItemInHand(null);
        } else {
            eq.setItemInHand(item.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    @Nullable
    public ItemStack getItemInOffHand() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return null;
        }
        if (BukkitFeature.OFF_HAND.isSupported()) {
            return new BukkitItem(eq.getItemInOffHand());
        }
        return ItemStackFactory.getAir();
    }

    @Override
    public void setItemInOffHand(@Nullable ItemStack item) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (BukkitFeature.OFF_HAND.isSupported()) {
            if (item == null) {
                eq.setItemInOffHand(null);
            } else {
                eq.setItemInOffHand(item.as(org.bukkit.inventory.ItemStack.class));
            }
        } else if (item != null && !item.isAir()) {
            Container inv = this.getInventory();
            if (inv != null) {
                List<ItemStack> failure = inv.addItem(item);
                if (!failure.isEmpty()) {
                    Location loc = ((org.bukkit.entity.Entity)this.wrappedObject).getLocation();
                    for (ItemStack fail : failure) {
                        loc.getWorld().dropItem(loc, fail.as(org.bukkit.inventory.ItemStack.class));
                    }
                }
            } else {
                Location loc = ((org.bukkit.entity.Entity)this.wrappedObject).getLocation();
                loc.getWorld().dropItem(loc, item.as(org.bukkit.inventory.ItemStack.class));
            }
        }
    }

    @Override
    @Nullable
    public ProjectileEntity launchProjectile(@NotNull sba.sl.e.type.EntityType projectileType) {
        Class projectileBukkit = projectileType.as(EntityType.class).getEntityClass();
        if (!Projectile.class.isAssignableFrom(projectileBukkit)) {
            return null;
        }
        return Entities.wrapEntityProjectile(((LivingEntity)this.wrappedObject).launchProjectile(projectileBukkit));
    }

    @Override
    @Nullable
    public ProjectileEntity launchProjectile(@NotNull sba.sl.e.type.EntityType projectileType, @NotNull Vector3D velocity) {
        Class projectileBukkit = projectileType.as(EntityType.class).getEntityClass();
        if (!Projectile.class.isAssignableFrom(projectileBukkit)) {
            return null;
        }
        return Entities.wrapEntityProjectile(((LivingEntity)this.wrappedObject).launchProjectile(projectileBukkit, new Vector(velocity.getX(), velocity.getY(), velocity.getZ())));
    }
}

