/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity;

import org.bukkit.entity.Ambient;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.BukkitLivingEntity;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.world.entity.LivingEntityAccessor;
import sba.sl.impl.nms.accessors.world.entity.MobAccessor;
import sba.sl.u.reflect.Reflect;

public class BukkitMob
extends BukkitLivingEntity
implements sba.sl.e.Mob {
    public BukkitMob(@NotNull LivingEntity wrappedObject) {
        super(wrappedObject);
        if (BukkitFeature.MOB_INTERFACE.isSupported()) {
            if (!(wrappedObject instanceof Mob)) {
                throw new IllegalArgumentException("Wrapped object is not an instance of Mob!");
            }
        } else if (!(wrappedObject instanceof Slime || wrappedObject instanceof Creature || wrappedObject instanceof Ambient || wrappedObject instanceof Flying || wrappedObject instanceof EnderDragon)) {
            throw new IllegalArgumentException("Wrapped object is not an instance of Slime, Creature, Ambient, Flying, WaterMob or EnderDragon!");
        }
    }

    @Override
    public void setCurrentTarget(@Nullable sba.sl.e.LivingEntity target) {
        LivingEntity living;
        LivingEntity livingEntity = living = target == null ? null : target.as(LivingEntity.class);
        if (BukkitFeature.MOB_INTERFACE.isSupported() && (!(this.wrappedObject instanceof EnderDragon) || BukkitFeature.ENDER_DRAGON_EXTEND_MOB_INTERFACE_IN_API.isSupported())) {
            ((Mob)this.wrappedObject).setTarget(living);
        } else if (this.wrappedObject instanceof Slime) {
            if (BukkitFeature.SLIME_TARGET.isSupported()) {
                ((Slime)this.wrappedObject).setTarget(living);
            } else {
                Reflect.getMethod(ClassStorage.getHandle(this.wrappedObject), MobAccessor.METHOD_SET_TARGET.get().getName(), LivingEntityAccessor.TYPE.get(), EntityTargetEvent.TargetReason.class, Boolean.TYPE).invoke(target != null ? ClassStorage.getHandle(target) : null, null, false);
            }
        } else if (this.wrappedObject instanceof Creature) {
            ((Creature)this.wrappedObject).setTarget(living);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public sba.sl.e.LivingEntity getCurrentTarget() {
        LivingEntity living;
        if (BukkitFeature.MOB_INTERFACE.isSupported()) {
            living = ((Mob)this.wrappedObject).getTarget();
            return Entities.wrapEntityLiving(living);
        }
        if (!(this.wrappedObject instanceof Slime)) {
            if (!(this.wrappedObject instanceof Creature)) return null;
            living = ((Creature)this.wrappedObject).getTarget();
            return Entities.wrapEntityLiving(living);
        }
        if (BukkitFeature.SLIME_TARGET.isSupported()) {
            living = ((Slime)this.wrappedObject).getTarget();
            return Entities.wrapEntityLiving(living);
        }
        Object result = Reflect.fastInvoke(ClassStorage.getHandle(this.wrappedObject), MobAccessor.METHOD_GET_TARGET.get());
        if (result == null) return null;
        return Entities.wrapEntityLiving(Reflect.fastInvoke(result, "getBukkitEntity"));
    }
}

