/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity;

import com.viaversion.viaversion.api.Via;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.WeatherType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import protocolsupport.api.ProtocolSupportAPI;
import sba.sl.Server;
import sba.sl.cn.Container;
import sba.sl.cn.ContainerFactory;
import sba.sl.cn.Openable;
import sba.sl.cn.PlayerContainer;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.BukkitHumanEntity;
import sba.sl.impl.bukkit.particle.BukkitParticleConverter;
import sba.sl.impl.bukkit.particle.BukkitParticleConverter1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundLevelParticlesPacketAccessor;
import sba.sl.impl.nms.accessors.server.VVV.EnumParticleAccessor;
import sba.sl.impl.nms.accessors.server.level.ServerPlayerAccessor;
import sba.sl.impl.world.Locations;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.pa.gamemode.GameMode;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.audience.adapter.PlayerAdapter;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;

public class BukkitPlayer
extends BukkitHumanEntity
implements Player {
    public BukkitPlayer(@NotNull org.bukkit.entity.Player wrappedObject) {
        super((HumanEntity)wrappedObject);
    }

    @Override
    public boolean isSprinting() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isSprinting();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        ((org.bukkit.entity.Player)this.wrappedObject).setSprinting(sprinting);
    }

    @Override
    public boolean isFlying() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isFlying();
    }

    @Override
    public void setFlying(boolean flying) {
        ((org.bukkit.entity.Player)this.wrappedObject).setFlying(flying);
    }

    @Override
    public boolean isAllowFlight() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getAllowFlight();
    }

    @Override
    public void setAllowFlight(boolean flying) {
        ((org.bukkit.entity.Player)this.wrappedObject).setAllowFlight(flying);
    }

    @Override
    public boolean isSneaking() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isSneaking();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        ((org.bukkit.entity.Player)this.wrappedObject).setSneaking(sneaking);
    }

    @Override
    public int getPing() {
        Object handle = ClassStorage.getHandle(this.wrappedObject);
        return Objects.requireNonNullElse(Reflect.getField(handle, ServerPlayerAccessor.FIELD_LATENCY.get()), 0);
    }

    @Override
    @Nullable
    public Component getPlayerListName() {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(bukkitPlayer.playerListName());
        }
        return Component.fromLegacy(bukkitPlayer.getPlayerListName());
    }

    @Override
    public void setPlayerListName(@Nullable Component component) {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            bukkitPlayer.playerListName(component == null ? null : component.as(sba.k.a.t.Component.class));
        } else {
            bukkitPlayer.setPlayerListName(component == null ? null : component.toLegacy());
        }
    }

    @Override
    public void setPlayerListName(@Nullable ComponentLike component) {
        this.setPlayerListName(component != null ? component.asComponent() : null);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(bukkitPlayer.displayName());
        }
        return Component.fromLegacy(bukkitPlayer.getDisplayName());
    }

    @Override
    public void setDisplayName(@Nullable Component component) {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            bukkitPlayer.displayName(component == null ? null : component.as(sba.k.a.t.Component.class));
        } else {
            bukkitPlayer.setDisplayName(component == null ? null : component.toLegacy());
        }
    }

    @Override
    public void setDisplayName(@Nullable ComponentLike component) {
        this.setDisplayName(component != null ? component.asComponent() : null);
    }

    @Override
    @NotNull
    public String getName() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getName();
    }

    @Override
    public void tryToDispatchCommand(@NotNull String command) {
        Bukkit.dispatchCommand((CommandSender)((CommandSender)this.wrappedObject), (String)command);
    }

    @Override
    @NotNull
    public Locale getLocale() {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        Locale locale = Locale.US;
        if (BukkitFeature.PLAYER_GET_LOCALE.isSupported()) {
            String locale2 = bukkitPlayer.getLocale();
            try {
                locale = Locale.forLanguageTag(locale2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return locale;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).getUniqueId();
    }

    @Override
    @NotNull
    public Container getEnderChest() {
        return (Container)Preconditions.checkNotNull(ContainerFactory.wrapContainer(((org.bukkit.entity.Player)this.wrappedObject).getEnderChest()));
    }

    @Override
    @NotNull
    public PlayerContainer getPlayerInventory() {
        return Preconditions.checkNotNull((PlayerContainer)ContainerFactory.wrapContainer(((org.bukkit.entity.Player)this.wrappedObject).getInventory()));
    }

    @Override
    @Nullable
    public Container getOpenedInventory() {
        return ContainerFactory.wrapContainer(((org.bukkit.entity.Player)this.wrappedObject).getOpenInventory().getTopInventory());
    }

    @Override
    public void openInventory(@NotNull Openable container) {
        container.openInventory(this);
    }

    @Override
    public void closeInventory() {
        ((org.bukkit.entity.Player)this.wrappedObject).closeInventory();
    }

    @Override
    public void kick(@Nullable Component message) {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)this.wrappedObject;
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            bukkitPlayer.kick(message == null ? null : message.as(sba.k.a.t.Component.class));
        } else {
            bukkitPlayer.kickPlayer(message == null ? null : message.toLegacy());
        }
    }

    @Override
    public void kick(@Nullable ComponentLike message) {
        this.kick(message instanceof AudienceComponentLike ? ((AudienceComponentLike)message).asComponent(this) : (message != null ? message.asComponent() : null));
    }

    @Override
    @NotNull
    public GameMode getGameMode() {
        return GameMode.of(((org.bukkit.entity.Player)this.wrappedObject).getGameMode());
    }

    @Override
    public void setGameMode(@NotNull GameMode gameMode) {
        ((org.bukkit.entity.Player)this.wrappedObject).setGameMode(gameMode.as(org.bukkit.GameMode.class));
    }

    @Override
    public int getLevel() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getLevel();
    }

    @Override
    public float getExp() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getExp();
    }

    @Override
    public void setLevel(int level) {
        ((org.bukkit.entity.Player)this.wrappedObject).setLevel(level);
    }

    @Override
    public void setExp(float exp) {
        ((org.bukkit.entity.Player)this.wrappedObject).setExp(exp);
    }

    @Override
    public void forceUpdateInventory() {
        ((org.bukkit.entity.Player)this.wrappedObject).updateInventory();
    }

    @Override
    @Nullable
    public String getLastName() {
        return this.getName();
    }

    @Override
    @Nullable
    public sba.sl.w.weather.WeatherType getPlayerWeather() {
        return sba.sl.w.weather.WeatherType.ofNullable(((org.bukkit.entity.Player)this.wrappedObject).getPlayerWeather());
    }

    @Override
    public void setPlayerWeather(@Nullable sba.sl.w.weather.WeatherType weather) {
        if (weather == null) {
            ((org.bukkit.entity.Player)this.wrappedObject).resetPlayerWeather();
        } else {
            ((org.bukkit.entity.Player)this.wrappedObject).setPlayerWeather(weather.as(WeatherType.class));
        }
    }

    @Override
    public long getPlayerTime() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getPlayerTime();
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        ((org.bukkit.entity.Player)this.wrappedObject).setPlayerTime(time, relative);
    }

    @Override
    public void resetPlayerTime() {
        ((org.bukkit.entity.Player)this.wrappedObject).resetPlayerTime();
    }

    @Override
    public void sendParticle(@NotNull sba.sl.pa.Particle particle, @NotNull sba.sl.w.Location location) {
        if (!this.getLocation().getWorld().equals(location.getWorld())) {
            throw new IllegalArgumentException("The location of the sent particle is not in the correct world!");
        }
        if (BukkitFeature.PARTICLES_API.isSupported()) {
            ((org.bukkit.entity.Player)this.wrappedObject).spawnParticle(particle.particleType().as(Particle.class), location.as(Location.class), particle.count(), particle.offset().getX(), particle.offset().getY(), particle.offset().getZ(), particle.particleData(), particle.specialData() != null ? BukkitParticleConverter.convertParticleData(particle.specialData()) : null);
        } else {
            Object enumParticle = particle.particleType().as(EnumParticleAccessor.TYPE.get());
            Object packet = Reflect.construct(ClientboundLevelParticlesPacketAccessor.CONSTRUCTOR_0.get(), enumParticle, particle.longDistance(), Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf((float)particle.offset().getX()), Float.valueOf((float)particle.offset().getY()), Float.valueOf((float)particle.offset().getZ()), Float.valueOf((float)particle.particleData()), particle.count(), particle.specialData() != null ? BukkitParticleConverter1_8.convertParticleData(particle.specialData()) : new int[]{});
            ClassStorage.sendNMSConstructedPacket((org.bukkit.entity.Player)this.wrappedObject, packet);
        }
    }

    @Override
    public void setCompassTarget(@NotNull sba.sl.w.Location location) {
        ((org.bukkit.entity.Player)this.wrappedObject).setCompassTarget(location.as(Location.class));
    }

    @Override
    public void restoreDefaultScoreboard() {
        ((org.bukkit.entity.Player)this.wrappedObject).setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    @Override
    @Nullable
    public Entity getSpectatorTarget() {
        org.bukkit.entity.Entity target = ((org.bukkit.entity.Player)this.wrappedObject).getSpectatorTarget();
        if (target == null) {
            return null;
        }
        return Entities.wrapEntity(target);
    }

    @Override
    public void setSpectatorTarget(@Nullable Entity entity) {
        ((org.bukkit.entity.Player)this.wrappedObject).setSpectatorTarget(entity == null ? null : entity.as(org.bukkit.entity.Entity.class));
    }

    @Override
    public int getTotalExperience() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getTotalExperience();
    }

    @Override
    public void setTotalExperience(int exp) {
        ((org.bukkit.entity.Player)this.wrappedObject).setTotalExperience(exp);
    }

    @Override
    public void hidePlayer(@NotNull Player player) {
        if (BukkitFeature.PLAYER_HIDE_API_PLUGIN_TICKET.isSupported()) {
            ((org.bukkit.entity.Player)this.wrappedObject).hidePlayer(BukkitCore.getPlugin(), player.as(org.bukkit.entity.Player.class));
        } else {
            ((org.bukkit.entity.Player)this.wrappedObject).hidePlayer(player.as(org.bukkit.entity.Player.class));
        }
    }

    @Override
    public void showPlayer(@NotNull Player player) {
        if (BukkitFeature.PLAYER_HIDE_API_PLUGIN_TICKET.isSupported()) {
            ((org.bukkit.entity.Player)this.wrappedObject).showPlayer(BukkitCore.getPlugin(), player.as(org.bukkit.entity.Player.class));
        } else {
            ((org.bukkit.entity.Player)this.wrappedObject).showPlayer(player.as(org.bukkit.entity.Player.class));
        }
    }

    @Override
    @NotNull
    public sba.sl.w.Location getCompassTarget() {
        return Locations.wrapLocation(((org.bukkit.entity.Player)this.wrappedObject).getCompassTarget());
    }

    @Override
    @Nullable
    public InetSocketAddress getAddress() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getAddress();
    }

    @Override
    public void respawn() {
        ((org.bukkit.entity.Player)this.wrappedObject).spigot().respawn();
    }

    @Override
    public boolean transferred() {
        if (BukkitFeature.TRANSFER.isSupported()) {
            return ((org.bukkit.entity.Player)this.wrappedObject).isTransferred();
        }
        return false;
    }

    @Override
    public void transfer(@NotNull String host, int port) {
        if (!BukkitFeature.TRANSFER.isSupported()) {
            throw new UnsupportedOperationException("This server does not support transferring players using Transfer packets! Update to 1.20.5 or newer!");
        }
        ((org.bukkit.entity.Player)this.wrappedObject).transfer(host, port);
    }

    @Override
    public @NotNull CompletableFuture<byte @Nullable []> retrieveCookie(@NotNull ResourceLocation location) {
        if (!BukkitFeature.TRANSFER.isSupported()) {
            throw new UnsupportedOperationException("This server does not support client cookies! Update to 1.20.5 or newer!");
        }
        return ((org.bukkit.entity.Player)this.wrappedObject).retrieveCookie(new NamespacedKey(location.namespace(), location.path()));
    }

    @Override
    public void storeCookie(@NotNull ResourceLocation location, byte @NotNull [] value) {
        if (!BukkitFeature.TRANSFER.isSupported()) {
            throw new UnsupportedOperationException("This server does not support client cookies! Update to 1.20.5 or newer!");
        }
        ((org.bukkit.entity.Player)this.wrappedObject).storeCookie(new NamespacedKey(location.namespace(), location.path()), value);
    }

    @Override
    public int getProtocolVersion() {
        int version;
        if (Reflect.has("com.viaversion.viaversion.api.Via") && (version = Via.getAPI().getPlayerVersion(this.wrappedObject)) != -1) {
            return version;
        }
        if (Reflect.has("protocolsupport.api.ProtocolSupportAPI") && (version = ProtocolSupportAPI.getProtocolVersion((org.bukkit.entity.Player)((org.bukkit.entity.Player)this.wrappedObject)).getId()) != -1) {
            return version;
        }
        if (BukkitFeature.PLAYER_PROTOCOL_VERSION.isSupported() && (version = ((org.bukkit.entity.Player)this.wrappedObject).getProtocolVersion()) != -1) {
            return version;
        }
        return Server.getProtocolVersion();
    }

    @Override
    @Nullable
    public sba.sl.w.Location getBedLocation() {
        return Locations.resolve(((org.bukkit.entity.Player)this.wrappedObject).getBedSpawnLocation());
    }

    @Override
    public long getFirstPlayed() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getFirstPlayed();
    }

    @Override
    public long getLastPlayed() {
        return ((org.bukkit.entity.Player)this.wrappedObject).getLastPlayed();
    }

    @Override
    public boolean isBanned() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isBanned();
    }

    @Override
    public boolean isWhitelisted() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isWhitelisted();
    }

    @Override
    public void setWhitelisted(boolean whitelisted) {
        ((org.bukkit.entity.Player)this.wrappedObject).setWhitelisted(whitelisted);
    }

    @Override
    public boolean isOp() {
        return ((org.bukkit.entity.Entity)this.wrappedObject).isOp();
    }

    @Override
    public boolean isOnline() {
        return ((org.bukkit.entity.Player)this.wrappedObject).isOnline();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (UnsupportedOperationException ignored) {
            return Players.UNSAFE_getPlayerConverter().convert(this, type);
        }
    }

    @Override
    @NotNull
    public PlayerAdapter adapter() {
        return (PlayerAdapter)BukkitCore.getSpectatorBackend().adapter(this, (CommandSender)this.wrappedObject);
    }
}

