/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.type;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.type.EntityType;
import sba.sl.impl.bukkit.entity.type.BukkitEntityType1_11;
import sba.sl.impl.bukkit.entity.type.BukkitEntityTypeRegistry;
import sba.sl.impl.bukkit.entity.type.InternalEntityLegacyConstants;
import sba.sl.impl.entity.type.EntityTypeTagBackPorts;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitEntityTypeRegistry1_11
extends BukkitEntityTypeRegistry {
    public BukkitEntityTypeRegistry1_11() {
        this.specialType(org.bukkit.entity.EntityType.class, BukkitEntityType1_11::new);
    }

    @Override
    public void aliasMapping() {
        super.aliasMapping();
        Arrays.stream(org.bukkit.entity.EntityType.values()).forEach(type -> {
            List<String> backPorts = EntityTypeTagBackPorts.getPortedTags(new BukkitEntityType1_11((org.bukkit.entity.EntityType)type), s -> false, false);
            if (backPorts != null && !backPorts.isEmpty()) {
                tagBackPorts.put(type, backPorts);
            }
        });
    }

    @Override
    @Nullable
    protected EntityType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        String path = location.path();
        @Nullable String enumName = null;
        switch (path) {
            case "item": {
                enumName = "DROPPED_ITEM";
                break;
            }
            case "experience_orb": {
                enumName = "EXPERIENCE_ORB";
                break;
            }
            case "area_effect_cloud": {
                enumName = "AREA_EFFECT_CLOUD";
                break;
            }
            case "elder_guardian": {
                enumName = "ELDER_GUARDIAN";
                break;
            }
            case "wither_skeleton": {
                enumName = "WITHER_SKELETON";
                break;
            }
            case "stray": {
                enumName = "STRAY";
                break;
            }
            case "egg": {
                enumName = "EGG";
                break;
            }
            case "leash_knot": {
                enumName = "LEASH_HITCH";
                break;
            }
            case "painting": {
                enumName = "PAINTING";
                break;
            }
            case "arrow": {
                enumName = "ARROW";
                break;
            }
            case "snowball": {
                enumName = "SNOWBALL";
                break;
            }
            case "fireball": {
                enumName = "FIREBALL";
                break;
            }
            case "small_fireball": {
                enumName = "SMALL_FIREBALL";
                break;
            }
            case "ender_pearl": {
                enumName = "ENDER_PEARL";
                break;
            }
            case "eye_of_ender": {
                enumName = "ENDER_SIGNAL";
                break;
            }
            case "potion": {
                enumName = "SPLASH_POTION";
                break;
            }
            case "experience_bottle": {
                enumName = "THROWN_EXP_BOTTLE";
                break;
            }
            case "item_frame": {
                enumName = "ITEM_FRAME";
                break;
            }
            case "wither_skull": {
                enumName = "WITHER_SKULL";
                break;
            }
            case "tnt": {
                enumName = "PRIMED_TNT";
                break;
            }
            case "falling_block": {
                enumName = "FALLING_BLOCK";
                break;
            }
            case "firework_rocket": {
                enumName = "FIREWORK";
                break;
            }
            case "husk": {
                enumName = "HUSK";
                break;
            }
            case "spectral_arrow": {
                enumName = "SPECTRAL_ARROW";
                break;
            }
            case "shulker_bullet": {
                enumName = "SHULKER_BULLET";
                break;
            }
            case "dragon_fireball": {
                enumName = "DRAGON_FIREBALL";
                break;
            }
            case "zombie_villager": {
                enumName = "ZOMBIE_VILLAGER";
                break;
            }
            case "skeleton_horse": {
                enumName = "SKELETON_HORSE";
                break;
            }
            case "zombie_horse": {
                enumName = "ZOMBIE_HORSE";
                break;
            }
            case "armor_stand": {
                enumName = "ARMOR_STAND";
                break;
            }
            case "donkey": {
                enumName = "DONKEY";
                break;
            }
            case "mule": {
                enumName = "MULE";
                break;
            }
            case "evoker_fangs": {
                enumName = "EVOKER_FANGS";
                break;
            }
            case "evoker": {
                enumName = "EVOKER";
                break;
            }
            case "vex": {
                enumName = "VEX";
                break;
            }
            case "vindicator": {
                enumName = "VINDICATOR";
                break;
            }
            case "illusioner": {
                enumName = "ILLUSIONER";
                break;
            }
            case "command_block_minecart": {
                enumName = "MINECART_COMMAND";
                break;
            }
            case "boat": {
                enumName = "BOAT";
                break;
            }
            case "minecart": {
                enumName = "MINECART";
                break;
            }
            case "chest_minecart": {
                enumName = "MINECART_CHEST";
                break;
            }
            case "furnace_minecart": {
                enumName = "MINECART_FURNACE";
                break;
            }
            case "tnt_minecart": {
                enumName = "MINECART_TNT";
                break;
            }
            case "hopper_minecart": {
                enumName = "MINECART_HOPPER";
                break;
            }
            case "spawner_minecart": {
                enumName = "MINECART_MOB_SPAWNER";
                break;
            }
            case "creeper": {
                enumName = "CREEPER";
                break;
            }
            case "skeleton": {
                enumName = "SKELETON";
                break;
            }
            case "spider": {
                enumName = "SPIDER";
                break;
            }
            case "giant": {
                enumName = "GIANT";
                break;
            }
            case "zombie": {
                enumName = "ZOMBIE";
                break;
            }
            case "slime": {
                enumName = "SLIME";
                break;
            }
            case "ghast": {
                enumName = "GHAST";
                break;
            }
            case "zombie_pigman": {
                enumName = "PIG_ZOMBIE";
                break;
            }
            case "enderman": {
                enumName = "ENDERMAN";
                break;
            }
            case "cave_spider": {
                enumName = "CAVE_SPIDER";
                break;
            }
            case "silverfish": {
                enumName = "SILVERFISH";
                break;
            }
            case "blaze": {
                enumName = "BLAZE";
                break;
            }
            case "magma_cube": {
                enumName = "MAGMA_CUBE";
                break;
            }
            case "ender_dragon": {
                enumName = "ENDER_DRAGON";
                break;
            }
            case "wither": {
                enumName = "WITHER";
                break;
            }
            case "bat": {
                enumName = "BAT";
                break;
            }
            case "witch": {
                enumName = "WITCH";
                break;
            }
            case "endermite": {
                enumName = "ENDERMITE";
                break;
            }
            case "guardian": {
                enumName = "GUARDIAN";
                break;
            }
            case "shulker": {
                enumName = "SHULKER";
                break;
            }
            case "pig": {
                enumName = "PIG";
                break;
            }
            case "sheep": {
                enumName = "SHEEP";
                break;
            }
            case "cow": {
                enumName = "COW";
                break;
            }
            case "chicken": {
                enumName = "CHICKEN";
                break;
            }
            case "squid": {
                enumName = "SQUID";
                break;
            }
            case "wolf": {
                enumName = "WOLF";
                break;
            }
            case "mooshroom": {
                enumName = "MUSHROOM_COW";
                break;
            }
            case "snow_golem": {
                enumName = "SNOWMAN";
                break;
            }
            case "ocelot": {
                enumName = "OCELOT";
                break;
            }
            case "iron_golem": {
                enumName = "IRON_GOLEM";
                break;
            }
            case "horse": {
                enumName = "HORSE";
                break;
            }
            case "rabbit": {
                enumName = "RABBIT";
                break;
            }
            case "polar_bear": {
                enumName = "POLAR_BEAR";
                break;
            }
            case "llama": {
                enumName = "LLAMA";
                break;
            }
            case "llama_spit": {
                enumName = "LLAMA_SPIT";
                break;
            }
            case "parrot": {
                enumName = "PARROT";
                break;
            }
            case "villager": {
                enumName = "VILLAGER";
                break;
            }
            case "end_crystal": {
                enumName = "ENDER_CRYSTAL";
                break;
            }
            case "turtle": {
                enumName = "TURTLE";
                break;
            }
            case "phantom": {
                enumName = "PHANTOM";
                break;
            }
            case "trident": {
                enumName = "TRIDENT";
                break;
            }
            case "cod": {
                enumName = "COD";
                break;
            }
            case "salmon": {
                enumName = "SALMON";
                break;
            }
            case "pufferfish": {
                enumName = "PUFFERFISH";
                break;
            }
            case "tropical_fish": {
                enumName = "TROPICAL_FISH";
                break;
            }
            case "drowned": {
                enumName = "DROWNED";
                break;
            }
            case "dolphin": {
                enumName = "DOLPHIN";
                break;
            }
            case "fishing_bobber": {
                enumName = "FISHING_HOOK";
                break;
            }
            case "lightning_bolt": {
                enumName = "LIGHTNING";
                break;
            }
            case "player": {
                enumName = "PLAYER";
            }
        }
        if (enumName != null) {
            try {
                return new BukkitEntityType1_11(org.bukkit.entity.EntityType.valueOf((String)enumName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            return new BukkitEntityType1_11(org.bukkit.entity.EntityType.valueOf((String)path.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull EntityType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<org.bukkit.entity.EntityType, EntityType>(() -> Arrays.stream(org.bukkit.entity.EntityType.values()).filter(e -> e != org.bukkit.entity.EntityType.UNKNOWN), BukkitEntityType1_11::new, InternalEntityLegacyConstants::translateLegacyName1_11, (entityType, literal) -> InternalEntityLegacyConstants.translateLegacyName1_11(entityType).path().contains((CharSequence)literal), (entityType, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

