/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.villager;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.entity.Villager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.villager.Profession;
import sba.sl.impl.bukkit.entity.villager.BukkitProfession1_8;
import sba.sl.impl.entity.villager.ProfessionRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitProfessionRegistry1_8
extends ProfessionRegistry {
    public BukkitProfessionRegistry1_8() {
        this.specialType(Villager.Profession.class, BukkitProfession1_8::new);
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull Profession> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Villager.Profession, Profession>(() -> Arrays.stream(Villager.Profession.values()).filter(profession -> !"NORMAL".equals(profession.name()) && !"HUSK".equals(profession.name())), BukkitProfession1_8::new, profession -> {
            if ("BLACKSMITH".equals(profession.name())) {
                return ResourceLocation.of("toolsmith");
            }
            if ("PRIEST".equals(profession.name())) {
                return ResourceLocation.of("cleric");
            }
            return ResourceLocation.of(profession.name());
        }, (profession, literal) -> {
            String path = profession.name().toLowerCase(Locale.ROOT);
            if ("blacksmith".equals(path) ? "toolsmith".contains((CharSequence)literal) : "priest".equals(path) && "cleric".contains((CharSequence)literal)) {
                return true;
            }
            return path.contains((CharSequence)literal);
        }, (profession, namespace) -> "minecraft".equals(namespace), List.of());
    }

    @Override
    @Nullable
    protected Profession resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            String enumName = location.path();
            if ("toolsmith".equalsIgnoreCase(enumName)) {
                enumName = "BLACKSMITH";
            } else if ("cleric".equalsIgnoreCase(enumName)) {
                enumName = "PRIEST";
            }
            Villager.Profession value = Villager.Profession.valueOf((String)enumName.toUpperCase(Locale.ROOT));
            return new BukkitProfession1_8(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

