/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.block;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.ev.block.BlockFertilizeEvent;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;
import sba.sl.pa.Player;

public class BukkitBlockFertilizeEvent
implements BlockFertilizeEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.block.BlockFertilizeEvent event;
    @Nullable
    private Player player;
    private boolean playerConverted;
    @Nullable
    private BlockPlacement block;
    private @Nullable Collection<@NotNull BlockSnapshot> changedBlockStates;

    @Override
    @Nullable
    public Player player() {
        if (!this.playerConverted) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitPlayer(this.event.getPlayer());
            }
            this.playerConverted = true;
        }
        return this.player;
    }

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull BlockSnapshot> changedBlockStates() {
        if (this.changedBlockStates == null) {
            this.changedBlockStates = new CollectionLinkedToCollection<BlockSnapshot, BlockState>(this.event.getBlocks(), o -> o.as(BlockState.class), o -> (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(o)));
        }
        return this.changedBlockStates;
    }

    @Generated
    public BukkitBlockFertilizeEvent(@NotNull org.bukkit.event.block.BlockFertilizeEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitBlockFertilizeEvent)) {
            return false;
        }
        BukkitBlockFertilizeEvent other = (BukkitBlockFertilizeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.block.BlockFertilizeEvent this$event = this.event();
        org.bukkit.event.block.BlockFertilizeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitBlockFertilizeEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.block.BlockFertilizeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitBlockFertilizeEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.block.BlockFertilizeEvent event() {
        return this.event;
    }
}

