/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import lombok.Generated;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.player.PlayerLeaveEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.pa.Player;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;

public class BukkitPlayerLeaveEvent
implements PlayerLeaveEvent {
    @NotNull
    private final PlayerQuitEvent event;
    @Nullable
    private Player player;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public Component leaveMessage() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return AdventureBackend.wrapComponent(this.event.quitMessage());
        }
        String qm = this.event.getQuitMessage();
        return qm != null ? Component.fromLegacy(qm) : null;
    }

    @Override
    public void leaveMessage(@Nullable Component leaveMessage) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            this.event.quitMessage(leaveMessage != null ? leaveMessage.as(sba.k.a.t.Component.class) : null);
        } else {
            this.event.setQuitMessage(leaveMessage != null ? leaveMessage.toLegacy() : null);
        }
    }

    @Override
    public void leaveMessage(@Nullable ComponentLike leaveMessage) {
        if (leaveMessage instanceof AudienceComponentLike) {
            this.leaveMessage(((AudienceComponentLike)leaveMessage).asComponent(this.player()));
        } else {
            this.leaveMessage(leaveMessage != null ? leaveMessage.asComponent() : null);
        }
    }

    @Generated
    public BukkitPlayerLeaveEvent(@NotNull PlayerQuitEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerLeaveEvent)) {
            return false;
        }
        BukkitPlayerLeaveEvent other = (BukkitPlayerLeaveEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerQuitEvent this$event = this.event();
        PlayerQuitEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerLeaveEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerQuitEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerLeaveEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public PlayerQuitEvent event() {
        return this.event;
    }
}

