/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.data;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagAdapterContext;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.data.ItemData;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.utils.GsonUtils;
import sba.sl.impl.utils.Primitives;
import sba.sl.u.ResourceLocation;

public class BukkitItemDataCustomTags
implements ItemData {
    @NotNull
    private static final List<Class<?>> BASE_TAGS = List.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, int[].class, byte[].class, long[].class);
    @NotNull
    private final CustomItemTagContainer dataContainer;

    public static boolean isWrapperType(@NotNull Class<?> clazz) {
        return BASE_TAGS.contains(clazz);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ResourceLocation> getKeys() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> void set(@NotNull String key, @NotNull T data, @NotNull Class<T> tClass) {
        this.set(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), data, tClass);
    }

    @Override
    public <T> void set(@NotNull ResourceLocation key, @NotNull T data, @NotNull Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        NamespacedKey namespacedKey = new NamespacedKey(key.namespace(), key.path());
        if (BukkitItemDataCustomTags.isWrapperType(tClass)) {
            if (data instanceof String) {
                String s = (String)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.STRING, (Object)s);
                return;
            }
            if (data instanceof Byte) {
                Byte s = (Byte)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.BYTE, (Object)s);
                return;
            }
            if (data instanceof Short) {
                Short s = (Short)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.SHORT, (Object)s);
                return;
            }
            if (data instanceof Integer) {
                Integer s = (Integer)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.INTEGER, (Object)s);
                return;
            }
            if (data instanceof Long) {
                Long s = (Long)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.LONG, (Object)s);
                return;
            }
            if (data instanceof Float) {
                Float s = (Float)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.FLOAT, (Object)s);
                return;
            }
            if (data instanceof Double) {
                Double s = (Double)data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.DOUBLE, (Object)s);
                return;
            }
            if (data instanceof byte[]) {
                byte[] s = (byte[])data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.BYTE_ARRAY, (Object)s);
                return;
            }
            if (data instanceof int[]) {
                int[] s = (int[])data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.INTEGER_ARRAY, (Object)s);
                return;
            }
            if (data instanceof long[]) {
                long[] s = (long[])data;
                this.dataContainer.setCustomTag(namespacedKey, ItemTagType.LONG_ARRAY, (Object)s);
                return;
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        this.dataContainer.setCustomTag(namespacedKey, new JsonPersistentDataType<T>(tClass), data);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String key, @NotNull Class<T> tClass) {
        return this.get(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), tClass);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull ResourceLocation key, @NotNull Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        NamespacedKey namespacedKey = new NamespacedKey(key.namespace(), key.path());
        if (BukkitItemDataCustomTags.isWrapperType(tClass)) {
            if (String.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.STRING);
            }
            if (Byte.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.BYTE);
            }
            if (Short.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.SHORT);
            }
            if (Integer.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.INTEGER);
            }
            if (Long.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.LONG);
            }
            if (Float.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.FLOAT);
            }
            if (Double.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.DOUBLE);
            }
            if (byte[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.BYTE_ARRAY);
            }
            if (int[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.INTEGER_ARRAY);
            }
            if (long[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.getCustomTag(namespacedKey, ItemTagType.LONG_ARRAY);
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        return (T)this.dataContainer.getCustomTag(namespacedKey, new JsonPersistentDataType<T>(tClass));
    }

    @Override
    public boolean contains(@NotNull String key) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public boolean contains(@NotNull ResourceLocation key) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public boolean isEmpty() {
        return this.dataContainer.isEmpty();
    }

    @Generated
    public BukkitItemDataCustomTags(@NotNull CustomItemTagContainer dataContainer) {
        if (dataContainer == null) {
            throw new NullPointerException("dataContainer is marked non-null but is null");
        }
        this.dataContainer = dataContainer;
    }

    @NotNull
    @Generated
    public CustomItemTagContainer getDataContainer() {
        return this.dataContainer;
    }

    public static class JsonPersistentDataType<T>
    implements ItemTagType<String, T> {
        @NotNull
        private final Class<T> tClass;

        public JsonPersistentDataType(@NotNull Class<T> tClass) {
            this.tClass = tClass;
        }

        @NotNull
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        @NotNull
        public Class<T> getComplexType() {
            return this.tClass;
        }

        @NotNull
        public String toPrimitive(@NotNull T complex, @NotNull ItemTagAdapterContext context) {
            return GsonUtils.gson().toJson(complex);
        }

        @NotNull
        public T fromPrimitive(@NotNull String primitive, @NotNull ItemTagAdapterContext context) {
            return (T)GsonUtils.gson().fromJson(primitive, this.tClass);
        }
    }
}

