/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.data;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.data.ItemData;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.utils.GsonUtils;
import sba.sl.impl.utils.Primitives;
import sba.sl.u.ResourceLocation;

public class BukkitItemDataPersistentContainer
implements ItemData {
    @NotNull
    private static final List<Class<?>> BASE_TAGS = List.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, int[].class, byte[].class, long[].class);
    @NotNull
    private final PersistentDataContainer dataContainer;

    public static boolean isWrapperType(@NotNull Class<?> clazz) {
        return BASE_TAGS.contains(clazz);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ResourceLocation> getKeys() {
        return this.dataContainer.getKeys().stream().map(k -> ResourceLocation.of(k.getNamespace(), k.getKey())).collect(Collectors.toSet());
    }

    @Override
    public <T> void set(@NotNull String key, @NotNull T data, @NotNull Class<T> tClass) {
        this.set(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), data, tClass);
    }

    @Override
    public <T> void set(@NotNull ResourceLocation key, @NotNull T data, @NotNull Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        NamespacedKey namespacedKey = new NamespacedKey(key.namespace(), key.path());
        if (BukkitItemDataPersistentContainer.isWrapperType(tClass)) {
            if (data instanceof String) {
                String s = (String)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)s);
                return;
            }
            if (data instanceof Byte) {
                Byte s = (Byte)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.BYTE, (Object)s);
                return;
            }
            if (data instanceof Short) {
                Short s = (Short)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.SHORT, (Object)s);
                return;
            }
            if (data instanceof Integer) {
                Integer s = (Integer)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)s);
                return;
            }
            if (data instanceof Long) {
                Long s = (Long)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.LONG, (Object)s);
                return;
            }
            if (data instanceof Float) {
                Float s = (Float)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.FLOAT, (Object)s);
                return;
            }
            if (data instanceof Double) {
                Double s = (Double)data;
                this.dataContainer.set(namespacedKey, PersistentDataType.DOUBLE, (Object)s);
                return;
            }
            if (data instanceof byte[]) {
                byte[] s = (byte[])data;
                this.dataContainer.set(namespacedKey, PersistentDataType.BYTE_ARRAY, (Object)s);
                return;
            }
            if (data instanceof int[]) {
                int[] s = (int[])data;
                this.dataContainer.set(namespacedKey, PersistentDataType.INTEGER_ARRAY, (Object)s);
                return;
            }
            if (data instanceof long[]) {
                long[] s = (long[])data;
                this.dataContainer.set(namespacedKey, PersistentDataType.LONG_ARRAY, (Object)s);
                return;
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        this.dataContainer.set(namespacedKey, new JsonPersistentDataType<T>(tClass), data);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String key, @NotNull Class<T> tClass) {
        return this.get(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), tClass);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull ResourceLocation key, @NotNull Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        NamespacedKey namespacedKey = new NamespacedKey(key.namespace(), key.path());
        if (BukkitItemDataPersistentContainer.isWrapperType(tClass)) {
            if (String.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.STRING);
            }
            if (Byte.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.BYTE);
            }
            if (Short.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.SHORT);
            }
            if (Integer.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.INTEGER);
            }
            if (Long.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.LONG);
            }
            if (Float.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.FLOAT);
            }
            if (Double.class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.DOUBLE);
            }
            if (byte[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.BYTE_ARRAY);
            }
            if (int[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.INTEGER_ARRAY);
            }
            if (long[].class.isAssignableFrom(tClass)) {
                return (T)this.dataContainer.get(namespacedKey, PersistentDataType.LONG_ARRAY);
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        return (T)this.dataContainer.get(namespacedKey, new JsonPersistentDataType<T>(tClass));
    }

    @Override
    public boolean contains(@NotNull String key) {
        return this.dataContainer.getKeys().stream().anyMatch(next -> next.getNamespace().equalsIgnoreCase(BukkitCore.getPlugin().getName()) && next.getKey().equalsIgnoreCase(key));
    }

    @Override
    public boolean contains(@NotNull ResourceLocation key) {
        return this.dataContainer.getKeys().stream().anyMatch(next -> next.getNamespace().equalsIgnoreCase(key.namespace()) && next.getKey().equalsIgnoreCase(key.path()));
    }

    @Override
    public boolean isEmpty() {
        return this.dataContainer.isEmpty();
    }

    @Generated
    public BukkitItemDataPersistentContainer(@NotNull PersistentDataContainer dataContainer) {
        if (dataContainer == null) {
            throw new NullPointerException("dataContainer is marked non-null but is null");
        }
        this.dataContainer = dataContainer;
    }

    @NotNull
    @Generated
    public PersistentDataContainer getDataContainer() {
        return this.dataContainer;
    }

    public static class JsonPersistentDataType<T>
    implements PersistentDataType<String, T> {
        @NotNull
        private final Class<T> tClass;

        public JsonPersistentDataType(@NotNull Class<T> tClass) {
            this.tClass = tClass;
        }

        @NotNull
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        @NotNull
        public Class<T> getComplexType() {
            return this.tClass;
        }

        @NotNull
        public String toPrimitive(@NotNull T complex, @NotNull PersistentDataAdapterContext context) {
            return GsonUtils.gson().toJson(complex);
        }

        @NotNull
        public T fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
            return (T)GsonUtils.gson().fromJson(primitive, this.tClass);
        }
    }
}

