/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.item.meta.BukkitEnchantmentType;
import sba.sl.impl.bukkit.utils.BukkitRegistry;
import sba.sl.impl.item.meta.EnchantmentTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitEnchantmentTypeRegistry
extends EnchantmentTypeRegistry {
    public BukkitEnchantmentTypeRegistry() {
        this.specialType(Enchantment.class, BukkitEnchantmentType::new);
    }

    @Override
    @Nullable
    protected EnchantmentType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (BukkitFeature.REGISTRY.isSupported()) {
            Enchantment value;
            BukkitEnchantmentType item = BukkitRegistry.tryObtainItem(Registry.ENCHANTMENT, BukkitEnchantmentType::new, location);
            if (item != null) {
                return item;
            }
            if ("minecraft".equals(location.namespace()) && (value = Enchantment.getByName((String)location.path().toUpperCase(Locale.ROOT))) != null) {
                return new BukkitEnchantmentType(value);
            }
        } else if (BukkitFeature.FLATTENING.isSupported()) {
            Enchantment value;
            Enchantment entityType = Enchantment.getByKey((NamespacedKey)new NamespacedKey(location.namespace(), location.path()));
            if (entityType != null) {
                return new BukkitEnchantmentType(entityType);
            }
            if ("minecraft".equals(location.namespace()) && (value = Enchantment.getByName((String)location.path().toUpperCase(Locale.ROOT))) != null) {
                return new BukkitEnchantmentType(value);
            }
        } else {
            String path;
            if (!"minecraft".equals(location.namespace())) {
                return null;
            }
            switch (path = location.path()) {
                case "protection": {
                    path = "PROTECTION_ENVIRONMENTAL";
                    break;
                }
                case "fire_protection": {
                    path = "PROTECTION_FIRE";
                    break;
                }
                case "feather_falling": {
                    path = "PROTECTION_FALL";
                    break;
                }
                case "blast_protection": {
                    path = "PROTECTION_EXPLOSIONS";
                    break;
                }
                case "projectile_protection": {
                    path = "PROTECTION_PROJECTILE";
                    break;
                }
                case "respiration": {
                    path = "OXYGEN";
                    break;
                }
                case "aqua_affinity": {
                    path = "WATER_WORKER";
                    break;
                }
                case "sharpness": {
                    path = "DAMAGE_ALL";
                    break;
                }
                case "smite": {
                    path = "DAMAGE_UNDEAD";
                    break;
                }
                case "bane_of_arthropods": {
                    path = "DAMAGE_ARTHROPODS";
                    break;
                }
                case "looting": {
                    path = "LOOT_BONUS_MOBS";
                    break;
                }
                case "sweeping": {
                    path = "SWEEPING_EDGE";
                    break;
                }
                case "efficiency": {
                    path = "DIG_SPEED";
                    break;
                }
                case "unbreaking": {
                    path = "DURABILITY";
                    break;
                }
                case "fortune": {
                    path = "LOOT_BONUS_BLOCKS";
                    break;
                }
                case "power": {
                    path = "ARROW_DAMAGE";
                    break;
                }
                case "punch": {
                    path = "ARROW_KNOCKBACK";
                    break;
                }
                case "flame": {
                    path = "ARROW_FIRE";
                    break;
                }
                case "infinity": {
                    path = "ARROW_INFINITE";
                    break;
                }
                case "luck_of_the_sea": {
                    path = "LUCK";
                }
            }
            String value = Enchantment.getByName((String)path.toUpperCase(Locale.ROOT));
            if (value != null) {
                return new BukkitEnchantmentType((Enchantment)value);
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull EnchantmentType> getRegistryItemStream0() {
        if (BukkitFeature.REGISTRY.isSupported()) {
            return BukkitRegistry.registryStream(Registry.ENCHANTMENT, BukkitEnchantmentType::new);
        }
        if (BukkitFeature.FLATTENING.isSupported()) {
            return new SimpleRegistryItemStream<Enchantment, EnchantmentType>(() -> Arrays.stream(Enchantment.values()), BukkitEnchantmentType::new, enchantment -> ResourceLocation.of(enchantment.getKey().getNamespace(), enchantment.getKey().getKey()), (enchantment, literal) -> enchantment.getKey().getKey().contains((CharSequence)literal), (enchantment, namespace) -> enchantment.getKey().getNamespace().equals(namespace), List.of());
        }
        return new SimpleRegistryItemStream<Enchantment, EnchantmentType>(() -> Arrays.stream(Enchantment.values()), BukkitEnchantmentType::new, enchantment -> ResourceLocation.of(BukkitEnchantmentType.getLocationPath(enchantment)), (enchantment, literal) -> BukkitEnchantmentType.getLocationPath(enchantment).contains((CharSequence)literal), (enchantment, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

