/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.PotionEffectType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.item.meta.BukkitPotionEffectType;
import sba.sl.impl.bukkit.utils.BukkitRegistry;
import sba.sl.impl.item.meta.PotionEffectTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitPotionEffectTypeRegistry
extends PotionEffectTypeRegistry {
    public BukkitPotionEffectTypeRegistry() {
        this.specialType(org.bukkit.potion.PotionEffectType.class, BukkitPotionEffectType::new);
    }

    @Override
    @Nullable
    protected PotionEffectType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (BukkitFeature.POTION_EFFECT_TYPE_REGISTRY_SPIGOT.isSupported()) {
            BukkitPotionEffectType item = BukkitRegistry.tryObtainItem(Registry.EFFECT, BukkitPotionEffectType::new, location);
            if (item != null) {
                return item;
            }
            if ("minecraft".equalsIgnoreCase(location.namespace())) {
                String path;
                switch (path = location.path()) {
                    case "slow": {
                        path = "slowness";
                        break;
                    }
                    case "fast_digging": {
                        path = "haste";
                        break;
                    }
                    case "slow_digging": {
                        path = "mining_fatigue";
                        break;
                    }
                    case "increase_damage": {
                        path = "strength";
                        break;
                    }
                    case "heal": {
                        path = "instant_health";
                        break;
                    }
                    case "harm": {
                        path = "instant_damage";
                        break;
                    }
                    case "jump": {
                        path = "jump_boost";
                        break;
                    }
                    case "confusion": {
                        path = "nausea";
                        break;
                    }
                    case "damage_resistance": {
                        path = "resistance";
                    }
                }
                return BukkitRegistry.tryObtainItem(Registry.EFFECT, BukkitPotionEffectType::new, ResourceLocation.of("minecraft", path));
            }
        } else if (BukkitFeature.POTION_EFFECT_TYPE_REGISTRY.isSupported()) {
            BukkitPotionEffectType item = BukkitRegistry.tryObtainItem(Registry.POTION_EFFECT_TYPE, BukkitPotionEffectType::new, location);
            if (item != null) {
                return item;
            }
            if ("minecraft".equalsIgnoreCase(location.namespace())) {
                String path;
                switch (path = location.path()) {
                    case "slow": {
                        path = "slowness";
                        break;
                    }
                    case "fast_digging": {
                        path = "haste";
                        break;
                    }
                    case "slow_digging": {
                        path = "mining_fatigue";
                        break;
                    }
                    case "increase_damage": {
                        path = "strength";
                        break;
                    }
                    case "heal": {
                        path = "instant_health";
                        break;
                    }
                    case "harm": {
                        path = "instant_damage";
                        break;
                    }
                    case "jump": {
                        path = "jump_boost";
                        break;
                    }
                    case "confusion": {
                        path = "nausea";
                        break;
                    }
                    case "damage_resistance": {
                        path = "resistance";
                    }
                }
                return BukkitRegistry.tryObtainItem(Registry.POTION_EFFECT_TYPE, BukkitPotionEffectType::new, ResourceLocation.of("minecraft", path));
            }
        } else if (BukkitFeature.POTION_EFFECT_KEYED.isSupported()) {
            org.bukkit.potion.PotionEffectType potionEffectType = org.bukkit.potion.PotionEffectType.getByKey((NamespacedKey)new NamespacedKey(location.namespace(), location.path()));
            if (potionEffectType != null) {
                return new BukkitPotionEffectType(potionEffectType);
            }
            if ("minecraft".equalsIgnoreCase(location.namespace())) {
                String path;
                switch (path = location.path()) {
                    case "slow": {
                        path = "slowness";
                        break;
                    }
                    case "fast_digging": {
                        path = "haste";
                        break;
                    }
                    case "slow_digging": {
                        path = "mining_fatigue";
                        break;
                    }
                    case "increase_damage": {
                        path = "strength";
                        break;
                    }
                    case "heal": {
                        path = "instant_health";
                        break;
                    }
                    case "harm": {
                        path = "instant_damage";
                        break;
                    }
                    case "jump": {
                        path = "jump_boost";
                        break;
                    }
                    case "confusion": {
                        path = "nausea";
                        break;
                    }
                    case "damage_resistance": {
                        path = "resistance";
                    }
                }
                potionEffectType = org.bukkit.potion.PotionEffectType.getByKey((NamespacedKey)new NamespacedKey("minecraft", path));
                if (potionEffectType != null) {
                    return new BukkitPotionEffectType(potionEffectType);
                }
            }
        } else {
            String path;
            if (!"minecraft".equals(location.namespace())) {
                return null;
            }
            switch (path = location.path()) {
                case "slowness": {
                    path = "SLOW";
                    break;
                }
                case "haste": {
                    path = "FAST_DIGGING";
                    break;
                }
                case "mining_fatigue": {
                    path = "SLOW_DIGGING";
                    break;
                }
                case "strength": {
                    path = "INCREASE_DAMAGE";
                    break;
                }
                case "instant_health": {
                    path = "HEAL";
                    break;
                }
                case "instant_damage": {
                    path = "HARM";
                    break;
                }
                case "jump_boost": {
                    path = "JUMP";
                    break;
                }
                case "nausea": {
                    path = "CONFUSION";
                    break;
                }
                case "resistance": {
                    path = "DAMAGE_RESISTANCE";
                }
            }
            org.bukkit.potion.PotionEffectType value = org.bukkit.potion.PotionEffectType.getByName((String)path.toUpperCase(Locale.ROOT));
            if (value != null) {
                return new BukkitPotionEffectType(value);
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull PotionEffectType> getRegistryItemStream0() {
        if (BukkitFeature.POTION_EFFECT_TYPE_REGISTRY_SPIGOT.isSupported()) {
            return BukkitRegistry.registryStream(Registry.EFFECT, BukkitPotionEffectType::new);
        }
        if (BukkitFeature.POTION_EFFECT_TYPE_REGISTRY.isSupported()) {
            return BukkitRegistry.registryStream(Registry.POTION_EFFECT_TYPE, BukkitPotionEffectType::new);
        }
        if (BukkitFeature.POTION_EFFECT_KEYED.isSupported()) {
            return new SimpleRegistryItemStream<org.bukkit.potion.PotionEffectType, PotionEffectType>(() -> Arrays.stream(org.bukkit.potion.PotionEffectType.values()), BukkitPotionEffectType::new, potionEffect -> ResourceLocation.of(potionEffect.getKey().getNamespace(), potionEffect.getKey().getKey()), (potionEffect, literal) -> potionEffect.getKey().getKey().contains((CharSequence)literal), (potionEffect, namespace) -> potionEffect.getKey().getNamespace().equals(namespace), List.of());
        }
        return new SimpleRegistryItemStream<org.bukkit.potion.PotionEffectType, PotionEffectType>(() -> Arrays.stream(org.bukkit.potion.PotionEffectType.values()), BukkitPotionEffectType::new, potionEffect -> ResourceLocation.of(BukkitPotionEffectType.getLocationPath(potionEffect)), (potionEffect, literal) -> BukkitPotionEffectType.getLocationPath(potionEffect).contains((CharSequence)literal), (potionEffect, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

