/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.player.gamemode;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.player.gamemode.BukkitGameMode;
import sba.sl.impl.player.gamemode.GameModeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.pa.gamemode.GameMode;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitGameModeRegistry
extends GameModeRegistry {
    public BukkitGameModeRegistry() {
        this.specialType(org.bukkit.GameMode.class, BukkitGameMode::new);
    }

    @Override
    @Nullable
    protected GameMode resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            org.bukkit.GameMode value = org.bukkit.GameMode.valueOf((String)location.path().toUpperCase(Locale.ROOT));
            return new BukkitGameMode(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull GameMode> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<org.bukkit.GameMode, GameMode>(() -> Arrays.stream(org.bukkit.GameMode.values()), BukkitGameMode::new, gameMode -> ResourceLocation.of(gameMode.name()), (gameMode, literal) -> gameMode.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (gameMode, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

