/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.sound;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitServer;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.spectator.sound.SoundStop;
import sba.sl.u.ResourceLocation;

public class BukkitSoundStop
implements SoundStop {
    @Nullable
    private final ResourceLocation soundKey;
    @Nullable
    private final SoundSource source;

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Bukkit doesn't have any class for stopping custom sounds, just methods");
    }

    @Override
    @NotNull
    public Object raw() {
        throw new UnsupportedOperationException("Bukkit doesn't have any class for stopping custom sounds, just methods");
    }

    @Override
    @NotNull
    public SoundStop withSoundKey(@Nullable ResourceLocation soundKey) {
        return new BukkitSoundStop(soundKey, this.source);
    }

    @Override
    @NotNull
    public SoundStop withSource(@Nullable SoundSource source) {
        return new BukkitSoundStop(this.soundKey, source);
    }

    @Override
    public @NotNull SoundStop.Builder toBuilder() {
        return new BukkitSoundStartBuilder(this.soundKey, this.source);
    }

    @Generated
    public BukkitSoundStop(@Nullable ResourceLocation soundKey, @Nullable SoundSource source) {
        this.soundKey = soundKey;
        this.source = source;
    }

    @Override
    @Nullable
    @Generated
    public ResourceLocation soundKey() {
        return this.soundKey;
    }

    @Override
    @Nullable
    @Generated
    public SoundSource source() {
        return this.source;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitSoundStop)) {
            return false;
        }
        BukkitSoundStop other = (BukkitSoundStop)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$soundKey = this.soundKey();
        ResourceLocation other$soundKey = other.soundKey();
        if (this$soundKey == null ? other$soundKey != null : !((Object)this$soundKey).equals(other$soundKey)) {
            return false;
        }
        SoundSource this$source = this.source();
        SoundSource other$source = other.source();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitSoundStop;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $soundKey = this.soundKey();
        result = result * 59 + ($soundKey == null ? 43 : ((Object)$soundKey).hashCode());
        SoundSource $source = this.source();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitSoundStop(soundKey=" + String.valueOf(this.soundKey()) + ", source=" + String.valueOf(this.source()) + ")";
    }

    public static class BukkitSoundStartBuilder
    implements SoundStop.Builder {
        @Nullable
        private ResourceLocation soundKey;
        @Nullable
        private SoundSource source;

        @Override
        @NotNull
        public SoundStop.Builder soundKey(@Nullable ResourceLocation key) {
            if (key == null) {
                this.soundKey = null;
                return this;
            }
            this.soundKey = "minecraft".equals(key.namespace()) ? ResourceLocation.of("minecraft", BukkitServer.UNSAFE_normalizeSoundKey0(key.path())) : key;
            return this;
        }

        @Override
        @NotNull
        public SoundStop.Builder soundKey(@Nullable String key) {
            if (key == null) {
                this.soundKey = null;
                return this;
            }
            return this.soundKey(ResourceLocation.of(key));
        }

        @Override
        @NotNull
        public SoundStop build() {
            return new BukkitSoundStop(this.soundKey, this.source);
        }

        @Override
        @Generated
        public BukkitSoundStartBuilder source(@Nullable SoundSource source) {
            this.source = source;
            return this;
        }

        @Generated
        public BukkitSoundStartBuilder() {
        }

        @Generated
        public BukkitSoundStartBuilder(@Nullable ResourceLocation soundKey, @Nullable SoundSource source) {
            this.soundKey = soundKey;
            this.source = source;
        }
    }
}

