/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.utils;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public final class BukkitRegistry {
    @NotNull
    public static <T extends Keyed, I extends RegistryItem> @NotNull RegistryItemStream<@NotNull I> registryStream(@NotNull Registry<T> registry, @NotNull @NotNull Function<@NotNull T, @NotNull I> constructor) {
        return BukkitRegistry.registryStream(registry, constructor, null);
    }

    @NotNull
    public static <T extends Keyed, I extends RegistryItem> @NotNull RegistryItemStream<@NotNull I> registryStream(@NotNull Registry<T> registry, @NotNull @NotNull Function<@NotNull T, @NotNull I> constructor, @Nullable Predicate<@NotNull T> filter) {
        @NotNull Supplier<@NotNull Stream<@NotNull Object>> streamSupplier = filter != null ? () -> BukkitRegistry.stream(registry).filter(filter) : () -> BukkitRegistry.stream(registry);
        return new SimpleRegistryItemStream<Keyed, I>(streamSupplier, constructor, BukkitRegistry::resourceLocation, (item, literal) -> item.getKey().getKey().contains((CharSequence)literal), (item, namespace) -> item.getKey().getNamespace().equals(namespace), List.of());
    }

    @Nullable
    public static <T extends Keyed, I extends RegistryItem> I tryObtainItem(@NotNull Registry<T> registry, @NotNull @NotNull Function<@NotNull T, @Nullable I> constructor, @NotNull ResourceLocation location) {
        return BukkitRegistry.tryObtainItem(registry, constructor, location, null);
    }

    @Nullable
    public static <T extends Keyed, I extends RegistryItem> I tryObtainItem(@NotNull Registry<T> registry, @NotNull @NotNull Function<@NotNull T, @Nullable I> constructor, @NotNull ResourceLocation location, @Nullable Predicate<@NotNull T> filter) {
        Keyed type = registry.get(new NamespacedKey(location.namespace(), location.path()));
        if (type != null && (filter == null || filter.test(type))) {
            return (I)((RegistryItem)constructor.apply(type));
        }
        return null;
    }

    @NotNull
    public static <T extends Keyed> Stream<T> stream(@NotNull Registry<T> registry) {
        if (BukkitFeature.REGISTRY_STREAM_METHOD.isSupported()) {
            return registry.stream();
        }
        return StreamSupport.stream(registry.spliterator(), false);
    }

    public static ResourceLocation resourceLocation(@NotNull Keyed keyed) {
        NamespacedKey key = keyed.getKey();
        return ResourceLocation.of(key.getNamespace(), key.getKey());
    }

    @Generated
    private BukkitRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

